package com.finconsgroup.itserr.marketplace.notification.bs.service;

import com.finconsgroup.itserr.marketplace.core.web.exception.WP2ResourceNotFoundException;
import com.finconsgroup.itserr.marketplace.notification.bs.client.dto.InputCreateUserNotificationDto;
import com.finconsgroup.itserr.marketplace.notification.bs.client.dto.InputPatchUserNotificationDto;
import com.finconsgroup.itserr.marketplace.notification.bs.client.dto.InputPatchUserNotificationsDto;
import com.finconsgroup.itserr.marketplace.notification.bs.client.dto.OutputPatchUserNotificationDto;
import com.finconsgroup.itserr.marketplace.notification.bs.client.dto.OutputUserNotificationDto;
import org.jetbrains.annotations.NotNull;
import org.springframework.lang.NonNull;

import java.util.List;
import java.util.UUID;

/**
 * Service for handling business logic related to UserNotification. This interface provides methods to retrieve, create, update, and delete UserNotification,
 */
public interface UserNotificationService {

    /**
     * Creates a new notification for user using the provided input data.
     *
     * @param inputCreateUserNotificationDto the input DTO containing user notification details
     * @param acceptLanguage Accept-Language header value. May be null.
     * @return the created notification.
     */
    @NotNull List<OutputUserNotificationDto> create(
            @NonNull InputCreateUserNotificationDto inputCreateUserNotificationDto,
            String acceptLanguage);

    /**
     * Updates an existing user notification by id with the provided data.
     *
     * @param notificationId the id of the user notification to update
     * @param inputPatchUserNotificationDto the input DTO containing updated user notification details
     * @return an OutputUserNotificationDto notificationDto representing the updated user notification
     * @throws WP2ResourceNotFoundException if no user notification is found with the given id
     */
    @NonNull
    OutputPatchUserNotificationDto patchById(@NonNull UUID notificationId, @NonNull InputPatchUserNotificationDto inputPatchUserNotificationDto);

    /**
     * Deletes a user notification by id. It will move the notification entity on a separated table containing deleted records.
     *
     * @param notificationId the id of the user notification to delete
     * @throws WP2ResourceNotFoundException if no user notification is found with the given id
     */
    void deleteById(@NonNull UUID notificationId);

    /**
     * Patches all user notifications.
     *
     * @param request Request.
     */
    void patchAll(@NonNull InputPatchUserNotificationsDto request);

}
