package com.finconsgroup.itserr.marketplace.notification.bs.service.impl;

import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.mail.SimpleMailMessage;
import org.springframework.mail.javamail.JavaMailSender;
import org.springframework.stereotype.Service;

@Slf4j
@Service
@RequiredArgsConstructor
public class EmailService {

    // Automatically configured by Spring Boot from spring.mail.* properties 💖
    private final JavaMailSender mailSender;

    // Sender email address from YAML configuration
    @Value("${spring.email.from}")
    private String fromAddress;

    /**
     * Sends a plain text email
     *
     * @param receiver recipient email address
     * @param subject email subject
     * @param body email body content
     * @return true if email was sent successfully, false otherwise
     */
    public boolean sendEmail(String receiver, String subject, String body) {
        try {
            // Create simple email message
            SimpleMailMessage message = new SimpleMailMessage();
            message.setFrom(fromAddress);
            message.setTo(receiver);
            message.setSubject(subject);
            message.setText(body);

            // Send email through SMTP relay
            mailSender.send(message);
            log.info("Email sent successfully to: {}", receiver);
            return true;

        } catch (Exception e) {
            log.error("Failed to send email to: {}", receiver, e);
            return false;
        }
    }
}