package com.finconsgroup.itserr.marketplace.notification.bs.websocket;

/**
 * Utility class that holds WebSocket session attribute constants.
 */
final class Attributes {

    /**
     * Private constructor to prevent instantiation.
     *
     * @throws UnsupportedOperationException always thrown to prevent instantiation
     */
    private Attributes() {
        throw new UnsupportedOperationException("Cannot instantiate");
    }

    /** Attribute key for storing user ID in WebSocket session */
    public static final String USER_ID_ATTR = "userId";
    /** Attribute key for storing username in WebSocket session */
    public static final String USERNAME_ATTR = "username";
    /** Attribute key for storing the email address of the user in the WebSocket session */
    public static final String EMAIL_ATTR = "email";
    /** Attribute key for storing Accept-Language header in WebSocket session */
    public static final String ACCEPT_LANGUAGE_ATTR = "acceptLanguage";

}
