package com.finconsgroup.itserr.marketplace.notification.bs.websocket.configuration.properties;

import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.springframework.boot.context.properties.ConfigurationProperties;

/**
 * Configuration properties for WebSocket CORS (Cross-Origin Resource Sharing) settings.
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
@ConfigurationProperties(prefix = "websocket.cors")
public class WebSocketCORSConfigurationProperties {

    /**
     * Specifies the allowed origins for cross-origin WebSocket requests. Defaults to *.
     */
    private String allowedOrigins = "*";

}
