/*
 * Decompiled with CFR 0.152.
 */
package com.finconsgroup.itserr.marketplace.notification.bs.client.dto;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.finconsgroup.itserr.marketplace.notification.bs.client.dto.OutputLocalizedUserNotificationDto;
import io.swagger.v3.oas.annotations.media.Schema;
import java.time.ZonedDateTime;
import java.util.UUID;
import lombok.Generated;

@Schema(name="OutputLocalizedUserNotificationDto", description="DTO representing a user notification with localized text")
public class OutputLocalizedUserNotificationDto {
    @Schema(description="Unique identifier of the user notification", example="550e8400-e29b-41d4-a716-446655440000")
    private UUID id;
    @Schema(description="The type of notification", example="catalog-item-event-created")
    private String type;
    @Schema(description="The notification message", example="A message")
    private String message;
    @Schema(description="ID of the referenced entity", example="12345")
    private String referencedId;
    @Schema(description="Flag indicating whether the notification has been read")
    private Boolean read;
    @Schema(description="Flag indicating whether the notification has been archived")
    private Boolean archived;
    @Schema(description="The last read time of the user notification", example="2025-04-06T10:15:30+01:00")
    @JsonFormat(shape=JsonFormat.Shape.STRING, pattern="yyyy-MM-dd'T'HH:mm:ssXXX")
    private ZonedDateTime lastReadTime;
    @Schema(description="The creation time of the notification", example="2025-04-06T10:15:30+01:00")
    @JsonFormat(shape=JsonFormat.Shape.STRING, pattern="yyyy-MM-dd'T'HH:mm:ssXXX")
    private ZonedDateTime creationTime;
    @Schema(description="The last update time of the notification", example="2025-04-06T10:15:30+01:00")
    @JsonFormat(shape=JsonFormat.Shape.STRING, pattern="yyyy-MM-dd'T'HH:mm:ssXXX")
    private ZonedDateTime updateTime;

    @Generated
    public static OutputLocalizedUserNotificationDtoBuilder builder() {
        return new OutputLocalizedUserNotificationDtoBuilder();
    }

    @Generated
    public UUID getId() {
        return this.id;
    }

    @Generated
    public String getType() {
        return this.type;
    }

    @Generated
    public String getMessage() {
        return this.message;
    }

    @Generated
    public String getReferencedId() {
        return this.referencedId;
    }

    @Generated
    public Boolean getRead() {
        return this.read;
    }

    @Generated
    public Boolean getArchived() {
        return this.archived;
    }

    @Generated
    public ZonedDateTime getLastReadTime() {
        return this.lastReadTime;
    }

    @Generated
    public ZonedDateTime getCreationTime() {
        return this.creationTime;
    }

    @Generated
    public ZonedDateTime getUpdateTime() {
        return this.updateTime;
    }

    @Generated
    public void setId(UUID id) {
        this.id = id;
    }

    @Generated
    public void setType(String type) {
        this.type = type;
    }

    @Generated
    public void setMessage(String message) {
        this.message = message;
    }

    @Generated
    public void setReferencedId(String referencedId) {
        this.referencedId = referencedId;
    }

    @Generated
    public void setRead(Boolean read) {
        this.read = read;
    }

    @Generated
    public void setArchived(Boolean archived) {
        this.archived = archived;
    }

    @Generated
    public void setLastReadTime(ZonedDateTime lastReadTime) {
        this.lastReadTime = lastReadTime;
    }

    @Generated
    public void setCreationTime(ZonedDateTime creationTime) {
        this.creationTime = creationTime;
    }

    @Generated
    public void setUpdateTime(ZonedDateTime updateTime) {
        this.updateTime = updateTime;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof OutputLocalizedUserNotificationDto)) {
            return false;
        }
        OutputLocalizedUserNotificationDto other = (OutputLocalizedUserNotificationDto)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Boolean this$read = this.getRead();
        Boolean other$read = other.getRead();
        if (this$read == null ? other$read != null : !((Object)this$read).equals(other$read)) {
            return false;
        }
        Boolean this$archived = this.getArchived();
        Boolean other$archived = other.getArchived();
        if (this$archived == null ? other$archived != null : !((Object)this$archived).equals(other$archived)) {
            return false;
        }
        UUID this$id = this.getId();
        UUID other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        String this$type = this.getType();
        String other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        String this$message = this.getMessage();
        String other$message = other.getMessage();
        if (this$message == null ? other$message != null : !this$message.equals(other$message)) {
            return false;
        }
        String this$referencedId = this.getReferencedId();
        String other$referencedId = other.getReferencedId();
        if (this$referencedId == null ? other$referencedId != null : !this$referencedId.equals(other$referencedId)) {
            return false;
        }
        ZonedDateTime this$lastReadTime = this.getLastReadTime();
        ZonedDateTime other$lastReadTime = other.getLastReadTime();
        if (this$lastReadTime == null ? other$lastReadTime != null : !((Object)this$lastReadTime).equals(other$lastReadTime)) {
            return false;
        }
        ZonedDateTime this$creationTime = this.getCreationTime();
        ZonedDateTime other$creationTime = other.getCreationTime();
        if (this$creationTime == null ? other$creationTime != null : !((Object)this$creationTime).equals(other$creationTime)) {
            return false;
        }
        ZonedDateTime this$updateTime = this.getUpdateTime();
        ZonedDateTime other$updateTime = other.getUpdateTime();
        return !(this$updateTime == null ? other$updateTime != null : !((Object)this$updateTime).equals(other$updateTime));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof OutputLocalizedUserNotificationDto;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $read = this.getRead();
        result = result * 59 + ($read == null ? 43 : ((Object)$read).hashCode());
        Boolean $archived = this.getArchived();
        result = result * 59 + ($archived == null ? 43 : ((Object)$archived).hashCode());
        UUID $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        String $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        String $message = this.getMessage();
        result = result * 59 + ($message == null ? 43 : $message.hashCode());
        String $referencedId = this.getReferencedId();
        result = result * 59 + ($referencedId == null ? 43 : $referencedId.hashCode());
        ZonedDateTime $lastReadTime = this.getLastReadTime();
        result = result * 59 + ($lastReadTime == null ? 43 : ((Object)$lastReadTime).hashCode());
        ZonedDateTime $creationTime = this.getCreationTime();
        result = result * 59 + ($creationTime == null ? 43 : ((Object)$creationTime).hashCode());
        ZonedDateTime $updateTime = this.getUpdateTime();
        result = result * 59 + ($updateTime == null ? 43 : ((Object)$updateTime).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "OutputLocalizedUserNotificationDto(id=" + String.valueOf(this.getId()) + ", type=" + this.getType() + ", message=" + this.getMessage() + ", referencedId=" + this.getReferencedId() + ", read=" + this.getRead() + ", archived=" + this.getArchived() + ", lastReadTime=" + String.valueOf(this.getLastReadTime()) + ", creationTime=" + String.valueOf(this.getCreationTime()) + ", updateTime=" + String.valueOf(this.getUpdateTime()) + ")";
    }

    @Generated
    public OutputLocalizedUserNotificationDto(UUID id, String type, String message, String referencedId, Boolean read, Boolean archived, ZonedDateTime lastReadTime, ZonedDateTime creationTime, ZonedDateTime updateTime) {
        this.id = id;
        this.type = type;
        this.message = message;
        this.referencedId = referencedId;
        this.read = read;
        this.archived = archived;
        this.lastReadTime = lastReadTime;
        this.creationTime = creationTime;
        this.updateTime = updateTime;
    }
}

