/*
 * Decompiled with CFR 0.152.
 */
package com.finconsgroup.itserr.marketplace.notification.bs.service.impl;

import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.mail.SimpleMailMessage;
import org.springframework.mail.javamail.JavaMailSender;
import org.springframework.stereotype.Service;

@Service
public class EmailService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(EmailService.class);
    private final JavaMailSender mailSender;
    @Value(value="${spring.email.from}")
    private String fromAddress;

    public boolean sendEmail(String receiver, String subject, String body) {
        try {
            SimpleMailMessage message = new SimpleMailMessage();
            message.setFrom(this.fromAddress);
            message.setTo(receiver);
            message.setSubject(subject);
            message.setText(body);
            this.mailSender.send(message);
            log.info("Email sent successfully to: {}", (Object)receiver);
            return true;
        }
        catch (Exception e) {
            log.error("Failed to send email to: {}", (Object)receiver, (Object)e);
            return false;
        }
    }

    @Generated
    public EmailService(JavaMailSender mailSender) {
        this.mailSender = mailSender;
    }
}

