/*
 * Decompiled with CFR 0.152.
 */
package com.finconsgroup.itserr.marketplace.notification.bs.websocket;

import com.finconsgroup.itserr.marketplace.notification.bs.websocket.WebSocketSessionInfo;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.Function;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;
import org.springframework.stereotype.Component;
import org.springframework.web.socket.CloseStatus;
import org.springframework.web.socket.TextMessage;
import org.springframework.web.socket.WebSocketMessage;
import org.springframework.web.socket.WebSocketSession;
import org.springframework.web.socket.handler.TextWebSocketHandler;

/*
 * Exception performing whole class analysis ignored.
 */
@Component
public class NotificationsWebSocketHandler
extends TextWebSocketHandler {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(NotificationsWebSocketHandler.class);
    private final Set<WebSocketSession> sessions = new HashSet();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void afterConnectionEstablished(@NonNull WebSocketSession session) {
        int sessionsCount;
        Set set = this.sessions;
        synchronized (set) {
            this.sessions.add(session);
            sessionsCount = this.sessions.size();
        }
        String username = NotificationsWebSocketHandler.getUsername((WebSocketSession)session);
        log.debug("Websocket connected: user={}, sessions={}", (Object)username, (Object)sessionsCount);
    }

    @Nullable
    private static String getUsername(@NonNull WebSocketSession session) {
        return Optional.of(session).map(WebSocketSession::getAttributes).map(m -> (String)m.get("username")).orElse(null);
    }

    @Nullable
    private static UUID getUserId(@NonNull WebSocketSession session) {
        return Optional.of(session).map(WebSocketSession::getAttributes).map(m -> (UUID)m.get("userId")).orElse(null);
    }

    @Nullable
    private static String getUserIdAsString(@NonNull WebSocketSession session) {
        return Optional.ofNullable(NotificationsWebSocketHandler.getUserId((WebSocketSession)session)).map(UUID::toString).orElse(null);
    }

    @Nullable
    private static String getEmail(@NonNull WebSocketSession session) {
        return Optional.of(session).map(WebSocketSession::getAttributes).map(m -> (String)m.get("email")).orElse(null);
    }

    @Nullable
    private static String getAcceptLanguage(@NonNull WebSocketSession session) {
        return Optional.of(session).map(WebSocketSession::getAttributes).map(m -> (String)m.get("acceptLanguage")).orElse(null);
    }

    protected void handleTextMessage(@NonNull WebSocketSession session, @NonNull TextMessage message) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void afterConnectionClosed(@NonNull WebSocketSession session, @NonNull CloseStatus status) {
        Set set = this.sessions;
        synchronized (set) {
            this.sessions.remove(session);
        }
        log.debug("Websocket closed: user={}, status={}, reason={}", new Object[]{NotificationsWebSocketHandler.getUsername((WebSocketSession)session), status.getCode(), status.getReason()});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    private List<WebSocketSession> findSessionsByUser(@NonNull String user) {
        String normalizedUser = StringUtils.lowerCase((String)user);
        Set set = this.sessions;
        synchronized (set) {
            return this.sessions.stream().filter(s -> normalizedUser == null || normalizedUser.equals(StringUtils.lowerCase((String)NotificationsWebSocketHandler.getUserIdAsString((WebSocketSession)s))) || normalizedUser.equals(StringUtils.lowerCase((String)NotificationsWebSocketHandler.getUsername((WebSocketSession)s))) || normalizedUser.equals(StringUtils.lowerCase((String)NotificationsWebSocketHandler.getEmail((WebSocketSession)s)))).toList();
        }
    }

    public void sendNoThrow(String message) {
        this.sendNoThrow((String)null, message);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendNoThrow(String user, String message) {
        List targetSessions;
        Set set = this.sessions;
        synchronized (set) {
            targetSessions = user != null ? this.findSessionsByUser(user) : new ArrayList(this.sessions);
        }
        for (WebSocketSession session : targetSessions) {
            this.sendNoThrow(session, message);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendNoThrow(String user, @NonNull Function<WebSocketSessionInfo, String> messageBuilder) {
        List targetSessions;
        Set set = this.sessions;
        synchronized (set) {
            targetSessions = user != null ? this.findSessionsByUser(user) : new ArrayList(this.sessions);
        }
        for (WebSocketSession session : targetSessions) {
            String message;
            WebSocketSessionInfo info = new WebSocketSessionInfo(NotificationsWebSocketHandler.getUserId((WebSocketSession)session), NotificationsWebSocketHandler.getAcceptLanguage((WebSocketSession)session));
            try {
                message = messageBuilder.apply(info);
            }
            catch (Exception e) {
                log.error("Error building websocket message", (Throwable)e);
                continue;
            }
            this.sendNoThrow(session, message);
        }
    }

    private void sendNoThrow(WebSocketSession session, String message) {
        try {
            this.send(session, message);
        }
        catch (Exception e) {
            log.error("Error sending websocket message", (Throwable)e);
        }
    }

    private void send(WebSocketSession session, String message) throws IOException {
        session.sendMessage((WebSocketMessage)new TextMessage((CharSequence)message));
    }
}

