/*
 * Decompiled with CFR 0.152.
 */
package com.finconsgroup.itserr.marketplace.notification.dm.dto;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.finconsgroup.itserr.marketplace.notification.dm.dto.OutputUserNotificationDto;
import io.swagger.v3.oas.annotations.media.Schema;
import java.time.ZonedDateTime;
import java.util.Map;
import java.util.UUID;
import lombok.Generated;

@Schema(name="OutputUserNotificationDto", description="DTO representing a user notification in responses")
public class OutputUserNotificationDto {
    @Schema(description="Unique identifier of the user notification", example="550e8400-e29b-41d4-a716-446655440000")
    private UUID id;
    @Schema(description="The user receiving the notification, represented as an UID, an username or an email", example="f81d4fae-7dec-11d0-a765-00a0c91e6bf6")
    private String user;
    @Schema(description="The type of notification", example="catalog-item-event-created")
    private String type;
    @Schema(description="ID of the referenced entity", example="12345")
    private String referencedId;
    @Schema(description="Placeholder values for notification template")
    private Map<String, String> placeholderValues;
    @Schema(description="Flag indicating whether the notification has been read")
    private Boolean read;
    @Schema(description="Flag indicating whether the notification has been archived")
    private Boolean archived;
    @Schema(description="The last read time of the user notification", example="2025-04-06T10:15:30+01:00")
    @JsonFormat(shape=JsonFormat.Shape.STRING, pattern="yyyy-MM-dd'T'HH:mm:ssXXX")
    private ZonedDateTime lastReadTime;
    @Schema(description="The creation time of the table record", example="2025-04-06T10:15:30+01:00")
    @JsonFormat(shape=JsonFormat.Shape.STRING, pattern="yyyy-MM-dd'T'HH:mm:ssXXX")
    private ZonedDateTime creationTime;
    @Schema(description="The last update time of the table record", example="2025-04-06T10:15:30+01:00")
    @JsonFormat(shape=JsonFormat.Shape.STRING, pattern="yyyy-MM-dd'T'HH:mm:ssXXX")
    private ZonedDateTime updateTime;

    @Generated
    public static OutputUserNotificationDtoBuilder builder() {
        return new OutputUserNotificationDtoBuilder();
    }

    @Generated
    public UUID getId() {
        return this.id;
    }

    @Generated
    public String getUser() {
        return this.user;
    }

    @Generated
    public String getType() {
        return this.type;
    }

    @Generated
    public String getReferencedId() {
        return this.referencedId;
    }

    @Generated
    public Map<String, String> getPlaceholderValues() {
        return this.placeholderValues;
    }

    @Generated
    public Boolean getRead() {
        return this.read;
    }

    @Generated
    public Boolean getArchived() {
        return this.archived;
    }

    @Generated
    public ZonedDateTime getLastReadTime() {
        return this.lastReadTime;
    }

    @Generated
    public ZonedDateTime getCreationTime() {
        return this.creationTime;
    }

    @Generated
    public ZonedDateTime getUpdateTime() {
        return this.updateTime;
    }

    @Generated
    public void setId(UUID id) {
        this.id = id;
    }

    @Generated
    public void setUser(String user) {
        this.user = user;
    }

    @Generated
    public void setType(String type) {
        this.type = type;
    }

    @Generated
    public void setReferencedId(String referencedId) {
        this.referencedId = referencedId;
    }

    @Generated
    public void setPlaceholderValues(Map<String, String> placeholderValues) {
        this.placeholderValues = placeholderValues;
    }

    @Generated
    public void setRead(Boolean read) {
        this.read = read;
    }

    @Generated
    public void setArchived(Boolean archived) {
        this.archived = archived;
    }

    @Generated
    public void setLastReadTime(ZonedDateTime lastReadTime) {
        this.lastReadTime = lastReadTime;
    }

    @Generated
    public void setCreationTime(ZonedDateTime creationTime) {
        this.creationTime = creationTime;
    }

    @Generated
    public void setUpdateTime(ZonedDateTime updateTime) {
        this.updateTime = updateTime;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof OutputUserNotificationDto)) {
            return false;
        }
        OutputUserNotificationDto other = (OutputUserNotificationDto)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Boolean this$read = this.getRead();
        Boolean other$read = other.getRead();
        if (this$read == null ? other$read != null : !((Object)this$read).equals(other$read)) {
            return false;
        }
        Boolean this$archived = this.getArchived();
        Boolean other$archived = other.getArchived();
        if (this$archived == null ? other$archived != null : !((Object)this$archived).equals(other$archived)) {
            return false;
        }
        UUID this$id = this.getId();
        UUID other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        String this$user = this.getUser();
        String other$user = other.getUser();
        if (this$user == null ? other$user != null : !this$user.equals(other$user)) {
            return false;
        }
        String this$type = this.getType();
        String other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        String this$referencedId = this.getReferencedId();
        String other$referencedId = other.getReferencedId();
        if (this$referencedId == null ? other$referencedId != null : !this$referencedId.equals(other$referencedId)) {
            return false;
        }
        Map this$placeholderValues = this.getPlaceholderValues();
        Map other$placeholderValues = other.getPlaceholderValues();
        if (this$placeholderValues == null ? other$placeholderValues != null : !((Object)this$placeholderValues).equals(other$placeholderValues)) {
            return false;
        }
        ZonedDateTime this$lastReadTime = this.getLastReadTime();
        ZonedDateTime other$lastReadTime = other.getLastReadTime();
        if (this$lastReadTime == null ? other$lastReadTime != null : !((Object)this$lastReadTime).equals(other$lastReadTime)) {
            return false;
        }
        ZonedDateTime this$creationTime = this.getCreationTime();
        ZonedDateTime other$creationTime = other.getCreationTime();
        if (this$creationTime == null ? other$creationTime != null : !((Object)this$creationTime).equals(other$creationTime)) {
            return false;
        }
        ZonedDateTime this$updateTime = this.getUpdateTime();
        ZonedDateTime other$updateTime = other.getUpdateTime();
        return !(this$updateTime == null ? other$updateTime != null : !((Object)this$updateTime).equals(other$updateTime));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof OutputUserNotificationDto;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $read = this.getRead();
        result = result * 59 + ($read == null ? 43 : ((Object)$read).hashCode());
        Boolean $archived = this.getArchived();
        result = result * 59 + ($archived == null ? 43 : ((Object)$archived).hashCode());
        UUID $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        String $user = this.getUser();
        result = result * 59 + ($user == null ? 43 : $user.hashCode());
        String $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        String $referencedId = this.getReferencedId();
        result = result * 59 + ($referencedId == null ? 43 : $referencedId.hashCode());
        Map $placeholderValues = this.getPlaceholderValues();
        result = result * 59 + ($placeholderValues == null ? 43 : ((Object)$placeholderValues).hashCode());
        ZonedDateTime $lastReadTime = this.getLastReadTime();
        result = result * 59 + ($lastReadTime == null ? 43 : ((Object)$lastReadTime).hashCode());
        ZonedDateTime $creationTime = this.getCreationTime();
        result = result * 59 + ($creationTime == null ? 43 : ((Object)$creationTime).hashCode());
        ZonedDateTime $updateTime = this.getUpdateTime();
        result = result * 59 + ($updateTime == null ? 43 : ((Object)$updateTime).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "OutputUserNotificationDto(id=" + String.valueOf(this.getId()) + ", user=" + this.getUser() + ", type=" + this.getType() + ", referencedId=" + this.getReferencedId() + ", placeholderValues=" + String.valueOf(this.getPlaceholderValues()) + ", read=" + this.getRead() + ", archived=" + this.getArchived() + ", lastReadTime=" + String.valueOf(this.getLastReadTime()) + ", creationTime=" + String.valueOf(this.getCreationTime()) + ", updateTime=" + String.valueOf(this.getUpdateTime()) + ")";
    }

    @Generated
    public OutputUserNotificationDto(UUID id, String user, String type, String referencedId, Map<String, String> placeholderValues, Boolean read, Boolean archived, ZonedDateTime lastReadTime, ZonedDateTime creationTime, ZonedDateTime updateTime) {
        this.id = id;
        this.user = user;
        this.type = type;
        this.referencedId = referencedId;
        this.placeholderValues = placeholderValues;
        this.read = read;
        this.archived = archived;
        this.lastReadTime = lastReadTime;
        this.creationTime = creationTime;
        this.updateTime = updateTime;
    }
}

