package com.finconsgroup.itserr.marketplace.notification.dm.dto;

import io.swagger.v3.oas.annotations.media.Schema;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;

import java.util.UUID;

/**
 * Output DTO representing a notification email template.
 */
@Data
@Builder
@AllArgsConstructor
public class OutputNotificationEmailTemplateDto {

    /**
     * The notification template identifier.
     */
    @Schema(description = "Unique identifier of the notification template", example = "550e8400-e29b-41d4-a716-446655440000")
    private UUID id;

    /**
     * The language code for the notification template (e.g., "en", "it", "fr"). Uses ISO 639-1 two-letter language codes.
     */
    @Schema(description = "The language code", example = "en")
    private String languageCode;

    /**
     * Default Email subject text
     */
    @Schema(description = "The subject text which may contain placeholders", example = "subject for {{title}}")
    private String subjectText;

    /**
     * Default Email body text
     */
    @Schema(description = "The body text which may contain placeholders", example = "body for {{title}}")
    private String bodyText;
}
