package com.finconsgroup.itserr.marketplace.notification.dm.dto;

import com.finconsgroup.itserr.marketplace.core.web.security.jwt.JwtTokenHolder;
import org.springframework.lang.NonNull;

import java.util.UUID;

/**
 * Data Transfer Object (DTO) representing user information. This record encapsulates essential user details including ID, username, and email.
 *
 * @param id Unique identifier for the user.
 * @param username Username of the user.
 * @param email Email address of the user.
 */
public record UserDto(
        @NonNull UUID id,
        @NonNull String username,
        @NonNull String email ) {

    /**
     * Creates a UserDto instance from the current security context.
     *
     * @return a new UserDto containing the current user's information
     * @throws RuntimeException if the required security information is not available
     */
    public static UserDto fromSecurityOrThrow() {

        final UUID userId = JwtTokenHolder.getUserIdOrThrow();
        final String userUsername = JwtTokenHolder.getPreferredUsernameOrThrow();
        final String userEmail = JwtTokenHolder.getEmailOrThrow();

        return new UserDto(userId, userUsername, userEmail);

    }

}
