package com.finconsgroup.itserr.marketplace.notification.dm.service;

import com.finconsgroup.itserr.marketplace.notification.dm.dto.OutputNotificationEmailTemplateDto;
import com.finconsgroup.itserr.marketplace.notification.dm.dto.OutputNotificationTemplateDto;
import org.springframework.lang.NonNull;

import java.util.List;
import java.util.Optional;

/**
 * Service for handling notification templates.
 */
public interface NotificationTemplateService {

    /**
     * Retrieves a notification template based on the specified notification type and language code.
     *
     * @param notificationType the type of the notification, used to identify the relevant template
     * @param languageCode     the ISO 639-1 two-letter language code specifying the language of the template
     * @return an Optional containing the matching OutputNotificationTemplateDto if found, or an empty Optional if no match is found
     */
    @NonNull
    Optional<OutputNotificationTemplateDto> findByTypeAndLanguage(
            @NonNull String notificationType,
            @NonNull String languageCode);

    /**
     * Retrieves a notification template based on the specified notification type.
     *
     * @param notificationType the type of the notification, used to identify the relevant template
     * @return a list containing the matching OutputNotificationTemplateDto if found, or an empty list if no match is found
     */
    @NonNull
    List<OutputNotificationTemplateDto> findByType(
            @NonNull String notificationType);

    /**
     * Retrieves all notification email template.
     *
     * @return a list containing the matching OutputNotificationEmailTemplateDto if found, or an empty list if no match is found
     */
    @NonNull
    List<OutputNotificationEmailTemplateDto> findAllEmailTemplates();

}
