/*
 * Decompiled with CFR 0.152.
 */
package com.finconsgroup.itserr.marketplace.notification.dm.service.impl;

import com.finconsgroup.itserr.marketplace.notification.dm.dto.OutputLocalizedUserNotificationDto;
import com.finconsgroup.itserr.marketplace.notification.dm.dto.OutputNotificationTemplateDto;
import com.finconsgroup.itserr.marketplace.notification.dm.dto.UserDto;
import com.finconsgroup.itserr.marketplace.notification.dm.entity.UserNotificationEntity;
import com.finconsgroup.itserr.marketplace.notification.dm.exception.UserNotificationNotFoundException;
import com.finconsgroup.itserr.marketplace.notification.dm.mapper.LocalizedUserNotificationMapper;
import com.finconsgroup.itserr.marketplace.notification.dm.repository.UserNotificationRepository;
import com.finconsgroup.itserr.marketplace.notification.dm.repository.specification.UserNotificationSpecifications;
import com.finconsgroup.itserr.marketplace.notification.dm.service.LanguageService;
import com.finconsgroup.itserr.marketplace.notification.dm.service.LocalizedUserNotificationService;
import com.finconsgroup.itserr.marketplace.notification.dm.service.NotificationTemplateService;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.lang.NonNull;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Service
public class DefaultLocalizedUserNotificationService
implements LocalizedUserNotificationService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DefaultLocalizedUserNotificationService.class);
    private final UserNotificationRepository userNotificationRepository;
    private final NotificationTemplateService notificationTemplateService;
    private final LocalizedUserNotificationMapper localizedUserNotificationMapper;
    private final LanguageService languageService;

    private OutputLocalizedUserNotificationDto toLocalizedDto(UserNotificationEntity entity, String httpAcceptLanguage) {
        List preferredLanguages = this.languageService.getPreferredLanguages(httpAcceptLanguage);
        OutputNotificationTemplateDto template = null;
        String type = entity.getType();
        for (String languageCode : preferredLanguages) {
            Optional templateOpt = this.notificationTemplateService.findByTypeAndLanguage(type, languageCode);
            if (!templateOpt.isPresent()) continue;
            template = (OutputNotificationTemplateDto)templateOpt.get();
            break;
        }
        return this.localizedUserNotificationMapper.toDto(entity, template != null ? template.getText() : type);
    }

    @NonNull
    @Transactional(propagation=Propagation.REQUIRED, readOnly=true, noRollbackFor={Exception.class})
    public Page<OutputLocalizedUserNotificationDto> findAll(@NonNull UserDto user, Boolean read, Boolean archived, @NonNull Pageable pageable, String httpAcceptLanguage) {
        PageRequest sortedPageable = PageRequest.of((int)pageable.getPageNumber(), (int)pageable.getPageSize(), (Sort)Sort.by((Sort.Direction)Sort.Direction.DESC, (String[])new String[]{"creationTime"}));
        return this.userNotificationRepository.findAll(UserNotificationSpecifications.user((UUID)user.id(), (String)user.username(), (String)user.email()).and(UserNotificationSpecifications.read((Boolean)read)).and(UserNotificationSpecifications.archived((Boolean)archived)), (Pageable)sortedPageable).map(n -> this.toLocalizedDto(n, httpAcceptLanguage));
    }

    @NonNull
    @Transactional(propagation=Propagation.REQUIRED, readOnly=true, noRollbackFor={Exception.class})
    public OutputLocalizedUserNotificationDto findById(@NonNull UUID notificationId, String httpAcceptLanguage) {
        return this.userNotificationRepository.findById((Object)notificationId).map(n -> this.toLocalizedDto(n, httpAcceptLanguage)).orElseThrow(() -> new UserNotificationNotFoundException(notificationId));
    }

    @NonNull
    @Transactional(propagation=Propagation.REQUIRED, readOnly=true, noRollbackFor={Exception.class})
    public OutputLocalizedUserNotificationDto findByUser(@NonNull UserDto user, @NonNull UUID notificationId, String httpAcceptLanguage) {
        return this.userNotificationRepository.findByUserAndId(user.id().toString(), user.username(), user.email(), notificationId).map(n -> this.toLocalizedDto(n, httpAcceptLanguage)).orElseThrow(() -> new UserNotificationNotFoundException(notificationId));
    }

    @Generated
    public DefaultLocalizedUserNotificationService(UserNotificationRepository userNotificationRepository, NotificationTemplateService notificationTemplateService, LocalizedUserNotificationMapper localizedUserNotificationMapper, LanguageService languageService) {
        this.userNotificationRepository = userNotificationRepository;
        this.notificationTemplateService = notificationTemplateService;
        this.localizedUserNotificationMapper = localizedUserNotificationMapper;
        this.languageService = languageService;
    }
}

