/*
 * Decompiled with CFR 0.152.
 */
package com.finconsgroup.itserr.marketplace.notificationfeeder.bs.event.extractor;

import com.finconsgroup.itserr.marketplace.notificationfeeder.bs.event.extractor.FieldExtractor;
import com.finconsgroup.itserr.marketplace.notificationfeeder.bs.exception.FieldExtractionException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;
import org.springframework.stereotype.Component;

@Component
public class FieldExtractorRegistry {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(FieldExtractorRegistry.class);
    private final List<FieldExtractor> extractors;

    @NonNull
    public List<String> extract(@NonNull String field, @NonNull Object source) {
        Exception lastException = null;
        for (FieldExtractor extractor : this.extractors) {
            try {
                return extractor.extract(field, source);
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
            }
            catch (Exception e) {
                log.error("Error extracting field '{}'", (Object)field, (Object)e);
                lastException = e;
            }
        }
        if (lastException != null) {
            throw new FieldExtractionException(field, source, lastException);
        }
        throw new UnsupportedOperationException("No extractor found for field '" + field + "' and given source");
    }

    public String extractPlaceholderValue(@NonNull String field, @NonNull Object source) {
        List values = this.extract(field, source);
        if (values.isEmpty()) {
            return null;
        }
        if (values.size() == 1) {
            return (String)values.getFirst();
        }
        return StringUtils.join((Iterable)values, (String)", ");
    }

    public Map<String, String> extractPlaceholders(@NonNull Map<String, String> placeholdersFieldsMap, @NonNull Object source) {
        HashMap<String, String> placeholders = new HashMap<String, String>();
        for (Map.Entry<String, String> entry : placeholdersFieldsMap.entrySet()) {
            String placeholderName = entry.getKey();
            String field = entry.getValue();
            String value = this.extractPlaceholderValue(field, source);
            if (value == null) continue;
            placeholders.put(placeholderName, value);
        }
        return placeholders;
    }

    @NonNull
    public Set<String> extractReceivers(@NonNull String field, @NonNull Object source) {
        return this.extract(field, source).stream().filter(Objects::nonNull).collect(Collectors.toSet());
    }

    @Nullable
    public String extractResourceId(@NonNull String field, @NonNull Object source) {
        return this.extract(field, source).stream().filter(Objects::nonNull).findFirst().orElse(null);
    }

    @Generated
    public FieldExtractorRegistry(List<FieldExtractor> extractors) {
        this.extractors = extractors;
    }
}

