/*
 * Decompiled with CFR 0.152.
 */
package com.finconsgroup.itserr.marketplace.notificationfeeder.bs.event.extractor;

import com.fasterxml.jackson.databind.JsonNode;
import com.finconsgroup.itserr.marketplace.notificationfeeder.bs.event.extractor.FieldExtractor;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.core.annotation.Order;
import org.springframework.lang.NonNull;
import org.springframework.stereotype.Component;

@Component
@Order(value=-2147483648)
public class JsonFieldExtractor
implements FieldExtractor {
    public static final String PREFIX = "$.";
    public static final int PREFIX_LENGTH = "$.".length();

    @NonNull
    public List<String> extract(@NonNull String field, @NonNull Object source) {
        if (!(source instanceof JsonNode)) {
            throw new UnsupportedOperationException("Source object should be a JsonNode instance");
        }
        JsonNode root = (JsonNode)source;
        if (!StringUtils.startsWith((CharSequence)field, (CharSequence)PREFIX)) {
            throw new UnsupportedOperationException("Field format not supported");
        }
        String[] fields = StringUtils.split((String)StringUtils.substring((String)field, (int)PREFIX_LENGTH), (String)".");
        return this.extract(root, fields).stream().map(JsonNode::asText).toList();
    }

    private List<JsonNode> extract(JsonNode root, String[] fields) {
        List<JsonNode> current = List.of(root);
        for (String f : fields) {
            ArrayList<JsonNode> next = new ArrayList<JsonNode>();
            for (JsonNode node : current) {
                JsonNode child = node.get(f);
                if (child == null) continue;
                if (child.isArray()) {
                    child.forEach(next::add);
                    continue;
                }
                next.add(child);
            }
            current = next;
            if (current.isEmpty()) break;
        }
        return current;
    }
}

