package com.finconsgroup.itserr.marketplace.notificationfeeder.bs;

import com.finconsgroup.itserr.marketplace.notificationfeeder.bs.config.properties.NotificationsConfigurationProperties;
import io.swagger.v3.oas.annotations.OpenAPIDefinition;
import io.swagger.v3.oas.annotations.info.Info;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.boot.context.properties.EnableConfigurationProperties;

@SpringBootApplication
@OpenAPIDefinition(info = @Info(
        title = "NotificationFeeder API",
        description = "API definition of the NotificationFeeder Microservice",
        version = "1.0.0"
))
@EnableConfigurationProperties(NotificationsConfigurationProperties.class)
public class NotificationFeederBsApplication {

    public static void main(String[] args) {
        SpringApplication.run(NotificationFeederBsApplication.class, args);
    }

}
