package com.finconsgroup.itserr.marketplace.notificationfeeder.bs.config.properties;

import jakarta.validation.constraints.NotBlank;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.SuperBuilder;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;
import org.springframework.validation.annotation.Validated;

import java.util.HashMap;
import java.util.Map;

/**
 * Base class for notification properties configuration. Serves as a parent class for specific notification property implementations.
 */
@Data
@SuperBuilder
@NoArgsConstructor
@AllArgsConstructor
@Validated
public class NotificationProperties {

    /** Notification type code. */
    @NotBlank
    private String type;

    /**
     * <p>Configures the source from which the linked resource id should be taken.</p>
     * <p>Allowed values are:
     * <ul>
     * <li><b>$.*</b>: if the source data is a JSON, contains the path the information should be taken from.<br>For example <code>$.user.id</code>, will return the id of the user object</li>
     * </ul>
     * </p>
     */
    @Nullable
    private String resource;

    /**
     * <p>Configures the source from which the receivers should be taken.</p>
     * <p>Allowed values are:
     * <ul>
     * <li><b>$.*</b>: if the source data is a JSON, contains the path the information should be taken from.<br>For example <code>$.user.id</code>, will return the id of the user object</li>
     * </ul>
     * </p>
     */
    @NotBlank
    private String receivers;

    /**
     * <p>A map of placeholder key-value pairs used to dynamically populate notification content.</p>
     * <p>The keys represent placeholder identifiers, and the values represent the corresponding
     * replacement values to be injected during notification generation.</p>
     * <p>Allowed values are:
     * <ul>
     * <li><b>$.*</b>: if the source data is a JSON, contains the path the information should be taken from.<br>For example <code>$.user.username</code>, will return the username of the user object</li>
     * </ul>
     * </p>
     */
    @NonNull
    @Builder.Default
    private Map<String, String> placeholders = new HashMap<>();

}
