/*
 * Decompiled with CFR 0.152.
 */
package com.finconsgroup.itserr.marketplace.notificationfeeder.bs.config;

import com.finconsgroup.itserr.marketplace.notificationfeeder.bs.config.NotificationConfiguration;
import com.finconsgroup.itserr.marketplace.notificationfeeder.bs.config.properties.BusDriverProperties;
import com.finconsgroup.itserr.marketplace.notificationfeeder.bs.config.properties.BusNotificationProperties;
import com.finconsgroup.itserr.marketplace.notificationfeeder.bs.config.properties.DriversProperties;
import com.finconsgroup.itserr.marketplace.notificationfeeder.bs.config.properties.NotificationsConfigurationProperties;
import com.finconsgroup.itserr.marketplace.notificationfeeder.bs.event.JsonNotificationConsumerMessageHandler;
import com.finconsgroup.itserr.marketplace.notificationfeeder.bs.event.JsonNotificationConsumerMessageHandlerFactory;
import com.finconsgroup.itserr.marketplace.notificationfeeder.bs.event.StreamMultiplexerConsumerMessageHandler;
import com.finconsgroup.itserr.marketplace.notificationfeeder.bs.event.StreamMultiplexerConsumerMessageHandlerFactory;
import com.finconsgroup.itserr.marketplace.notificationfeeder.bs.helper.MessagingHelper;
import com.finconsgroup.itserr.messaging.autoconfigure.MessagingConsumerProperties;
import com.finconsgroup.itserr.messaging.autoconfigure.MessagingStreamProperties;
import com.finconsgroup.itserr.messaging.enums.OffsetType;
import jakarta.annotation.PostConstruct;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Configuration;

@Configuration
public class NotificationConfiguration {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(NotificationConfiguration.class);
    private final NotificationsConfigurationProperties notificationsConfig;
    private final MessagingHelper messagingHelper;
    private final StreamMultiplexerConsumerMessageHandlerFactory streamMultiplexerConsumerMessageHandlerFactory;
    private final JsonNotificationConsumerMessageHandlerFactory jsonNotificationConsumerMessageHandlerFactory;

    @PostConstruct
    public void initialize() {
        List busNotifications = this.getBusNotifications();
        if (!busNotifications.isEmpty()) {
            this.configure((Collection)busNotifications);
        }
    }

    @NotNull
    private List<NamedBusNotificationProperties> getBusNotifications() {
        return Optional.ofNullable(this.notificationsConfig).map(NotificationsConfigurationProperties::getDrivers).map(DriversProperties::getBus).map(BusDriverProperties::getNotifications).orElseGet(HashMap::new).entrySet().stream().map(e -> new NamedBusNotificationProperties((String)e.getKey(), (BusNotificationProperties)e.getValue())).toList();
    }

    private void configure(Collection<NamedBusNotificationProperties> busNotifications) {
        Set streams = busNotifications.stream().map(NamedBusNotificationProperties::properties).map(BusNotificationProperties::getStream).collect(Collectors.toSet());
        Map<String, StreamMultiplexerConsumerMessageHandler> streamHandlerMap = streams.stream().collect(Collectors.toMap(stream -> stream, arg_0 -> this.configure(arg_0)));
        busNotifications.forEach(notification -> this.configure((StreamMultiplexerConsumerMessageHandler)streamHandlerMap.get(notification.properties.getStream()), notification));
    }

    private StreamMultiplexerConsumerMessageHandler configure(String stream) {
        log.debug("Configuring listeners for stream: {}", (Object)stream);
        StreamMultiplexerConsumerMessageHandler notificationsHandler = this.streamMultiplexerConsumerMessageHandlerFactory.create(stream);
        MessagingConsumerProperties consumerProperties = MessagingConsumerProperties.builder().enabled(true).name("notification-feeder-" + stream).handlerBeanName("busConsumer").concurrency(1).retryAttempts(3).retryBackoffMs(1000L).offsetStrategy(OffsetType.NEXT).singleActiveConsumer(false).dlq(this.notificationsConfig.getDrivers().getBus().getConsumer().getDlq()).build();
        MessagingStreamProperties streamProperties = MessagingStreamProperties.builder().name(stream).consumer(consumerProperties).build();
        List consumers = this.messagingHelper.createConsumers(streamProperties, Map.of("busConsumer", notificationsHandler));
        consumers.forEach(arg_0 -> ((MessagingHelper)this.messagingHelper).register(arg_0));
        return notificationsHandler;
    }

    private void configure(StreamMultiplexerConsumerMessageHandler streamHandler, NamedBusNotificationProperties notification) {
        log.debug("Configuring handler for notification: {}", (Object)notification.name);
        JsonNotificationConsumerMessageHandler notificationHandler = this.jsonNotificationConsumerMessageHandlerFactory.create(notification.name, notification.properties);
        streamHandler.addHandler(notificationHandler);
    }

    @Generated
    public NotificationConfiguration(NotificationsConfigurationProperties notificationsConfig, MessagingHelper messagingHelper, StreamMultiplexerConsumerMessageHandlerFactory streamMultiplexerConsumerMessageHandlerFactory, JsonNotificationConsumerMessageHandlerFactory jsonNotificationConsumerMessageHandlerFactory) {
        this.notificationsConfig = notificationsConfig;
        this.messagingHelper = messagingHelper;
        this.streamMultiplexerConsumerMessageHandlerFactory = streamMultiplexerConsumerMessageHandlerFactory;
        this.jsonNotificationConsumerMessageHandlerFactory = jsonNotificationConsumerMessageHandlerFactory;
    }
}

