/*
 * Decompiled with CFR 0.152.
 */
package com.finconsgroup.itserr.marketplace.notificationfeeder.bs.event;

import com.finconsgroup.itserr.marketplace.notificationfeeder.bs.event.JsonNotificationConsumerMessageHandler;
import com.finconsgroup.itserr.marketplace.notificationfeeder.bs.event.NotificationConsumerMessageHandler;
import com.finconsgroup.itserr.marketplace.notificationfeeder.bs.event.filter.ConsumerHandlerFilterRegistry;
import com.finconsgroup.itserr.messaging.consumer.handler.ConsumerMessageHandler;
import io.cloudevents.CloudEvent;
import io.cloudevents.CloudEventData;
import java.util.HashSet;
import java.util.Set;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StreamMultiplexerConsumerMessageHandler
implements ConsumerMessageHandler {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(StreamMultiplexerConsumerMessageHandler.class);
    private final String stream;
    private final Set<NotificationConsumerMessageHandler> handlers = new HashSet();
    private final ConsumerHandlerFilterRegistry handlersFilterRegistry;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addHandler(JsonNotificationConsumerMessageHandler handler) {
        Set set = this.handlers;
        synchronized (set) {
            this.handlers.add(handler);
        }
    }

    public void handleMessage(CloudEvent cloudEvent) {
        CloudEventData rawData = cloudEvent.getData();
        if (rawData == null) {
            return;
        }
        if (log.isTraceEnabled()) {
            String data = new String(rawData.toBytes());
            log.trace("Received event: id={}, stream={}, type={}, message={}", new Object[]{cloudEvent.getId(), this.stream, cloudEvent.getType(), data});
        } else {
            log.debug("Received event: id={}, stream={}, type={}", new Object[]{cloudEvent.getId(), this.stream, cloudEvent.getType()});
        }
        for (NotificationConsumerMessageHandler handler : this.handlers) {
            try {
                String handlerName = handler.getName();
                if (this.handlersFilterRegistry.supports(handler, cloudEvent)) {
                    log.trace("Propagating to handler {}", (Object)handlerName);
                    handler.handleMessage(cloudEvent);
                    continue;
                }
                log.trace("Skipping handler {} (does not support event)", (Object)handlerName);
            }
            catch (Exception e) {
                log.error("Error handling event: stream={}", (Object)this.stream, (Object)e);
            }
        }
    }

    @Generated
    public StreamMultiplexerConsumerMessageHandler(String stream, ConsumerHandlerFilterRegistry handlersFilterRegistry) {
        this.stream = stream;
        this.handlersFilterRegistry = handlersFilterRegistry;
    }

    @Generated
    public String getStream() {
        return this.stream;
    }
}

