/*
 * Decompiled with CFR 0.152.
 */
package com.finconsgroup.itserr.marketplace.search.bs.messaging;

import com.finconsgroup.itserr.marketplace.search.bs.client.dm.SearchDmClient;
import com.finconsgroup.itserr.marketplace.search.bs.config.properties.MessagingEventBsProperties;
import com.finconsgroup.itserr.marketplace.search.bs.config.properties.SearchBsConfigurationProperties;
import com.finconsgroup.itserr.marketplace.search.bs.messaging.AbstractResourceSubscriber;
import java.util.Objects;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component(value="eventResourceSubscriber")
public class EventResourceSubscriber
extends AbstractResourceSubscriber {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(EventResourceSubscriber.class);
    private final MessagingEventBsProperties messagingEventBsProperties;
    private final SearchDmClient searchDmClient;

    public EventResourceSubscriber(SearchBsConfigurationProperties searchBsConfigurationProperties, SearchDmClient searchDmClient) {
        this.messagingEventBsProperties = searchBsConfigurationProperties.getMessaging().getEventBs();
        this.searchDmClient = searchDmClient;
    }

    protected void handleResource(String resourceId, Object resourcePayload, String eventType) {
        log.debug("Processing event bs event, id: {}, payload: {}, type: {}", new Object[]{resourceId, resourcePayload, eventType});
        if (Objects.equals(eventType, this.messagingEventBsProperties.getResourceCreatedEventType()) || Objects.equals(eventType, this.messagingEventBsProperties.getResourceUpdatedEventType())) {
            this.searchDmClient.upsertEvent(resourceId, resourcePayload);
        } else if (Objects.equals(eventType, this.messagingEventBsProperties.getResourceDeletedEventType())) {
            this.searchDmClient.deleteEvent(resourceId);
        } else {
            log.error("Unsupported eventType: {} for resourceId: {}", (Object)eventType, (Object)resourceId);
        }
    }
}

