package com.finconsgroup.itserr.marketplace.search.bs.messaging;

import com.finconsgroup.itserr.marketplace.search.bs.client.dm.SearchDmClient;
import com.finconsgroup.itserr.marketplace.search.bs.config.properties.MessagingDiscussionBsProperties;
import com.finconsgroup.itserr.marketplace.search.bs.config.properties.SearchBsConfigurationProperties;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;

import java.util.Objects;

@Component("discussionResourceSubscriber")
@Slf4j
public class DiscussionResourceSubscriber extends AbstractResourceSubscriber {

    /**
     * Messaging configuration properties for discussion-bs events.
     */
    private final MessagingDiscussionBsProperties messagingDiscussionBsProperties;

    /**
     * The client used to interact with the search dm.
     */
    private final SearchDmClient searchDmClient;

    /**
     * Constructs the DiscussionResourceSubscriber
     *
     * @param searchBsConfigurationProperties the application configuration properties
     * @param searchDmClient                  http client for interacting with the search DM service
     */
    public DiscussionResourceSubscriber(
            SearchBsConfigurationProperties searchBsConfigurationProperties,
            SearchDmClient searchDmClient
    ) {
        this.messagingDiscussionBsProperties = searchBsConfigurationProperties.getMessaging().getDiscussionBs();
        this.searchDmClient = searchDmClient;
    }

    @Override
    protected void handleResource(String resourceId, Object resourcePayload, String eventType) {
        log.debug("Processing discussion bs event, id: {}, payload: {}, type: {}", resourceId, resourcePayload, eventType);
        if (Objects.equals(eventType, messagingDiscussionBsProperties.getResourceCreatedEventType()) ||
                Objects.equals(eventType, messagingDiscussionBsProperties.getResourceUpdatedEventType())) {
            searchDmClient.upsertDiscussion(resourceId, resourcePayload);
        } else if (Objects.equals(eventType, messagingDiscussionBsProperties.getResourceDeletedEventType())) {
            searchDmClient.deleteDiscussion(resourceId);
        } else {
            log.error("Unsupported eventType: {} for resourceId: {}", eventType, resourceId);
        }
    }
}
