/*
 * Decompiled with CFR 0.152.
 */
package com.finconsgroup.itserr.marketplace.search.bs.messaging;

import com.finconsgroup.itserr.marketplace.search.bs.client.dm.SearchDmClient;
import com.finconsgroup.itserr.marketplace.search.bs.config.properties.MessagingInstitutionalPageBsProperties;
import com.finconsgroup.itserr.marketplace.search.bs.config.properties.SearchBsConfigurationProperties;
import com.finconsgroup.itserr.marketplace.search.bs.messaging.AbstractResourceSubscriber;
import java.util.Objects;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component(value="institutionalPageResourceSubscriber")
public class InstitutionalPageResourceSubscriber
extends AbstractResourceSubscriber {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(InstitutionalPageResourceSubscriber.class);
    private final MessagingInstitutionalPageBsProperties messagingInstitutionalPageBsProperties;
    private final SearchDmClient searchDmClient;

    public InstitutionalPageResourceSubscriber(SearchBsConfigurationProperties searchBsConfigurationProperties, SearchDmClient searchDmClient) {
        this.messagingInstitutionalPageBsProperties = searchBsConfigurationProperties.getMessaging().getInstitutionalPageBs();
        this.searchDmClient = searchDmClient;
    }

    protected void handleResource(String resourceId, Object resourcePayload, String eventType) {
        log.debug("Processing institutional page event, id: {}, payload: {}, type: {}", new Object[]{resourceId, resourcePayload, eventType});
        if (Objects.equals(eventType, this.messagingInstitutionalPageBsProperties.getResourceCreatedEventType()) || Objects.equals(eventType, this.messagingInstitutionalPageBsProperties.getResourceUpdatedEventType())) {
            this.searchDmClient.upsertInstitutionalPage(resourceId, resourcePayload);
        } else if (Objects.equals(eventType, this.messagingInstitutionalPageBsProperties.getResourceDeletedEventType())) {
            this.searchDmClient.deleteInstitutionalPage(resourceId);
        } else {
            log.error("Unsupported eventType: {} for resourceId: {}", (Object)eventType, (Object)resourceId);
        }
    }
}

