package com.finconsgroup.itserr.marketplace.search.dm.dto;

import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Builder;
import lombok.Data;

/**
 * It represents the payload for cv field to create/update/read a User Profile search document.
 */
@Builder
@Schema(
    title = "User Profile search document cv DTO",
    description = "Represents the payload for cv field of a User Profile search document"
)
@Data
public class UserProfileCvDto {

    @Schema(
        description = "URL of the CV file",
        example = "https://example.com/cv.pdf")
    private String fileUrl;

    @Schema(
        description = "Filename of the CV",
        example = "Curriculum Vitae di John Doe")
    private String filename;

    @Schema(
        description = "Size of the CV file in bytes",
        example = "123456")
    private Long size;

}
