/*
 * Decompiled with CFR 0.152.
 */
package com.finconsgroup.itserr.marketplace.search.dm.controller;

import com.finconsgroup.itserr.marketplace.search.dm.api.CatalogApi;
import com.finconsgroup.itserr.marketplace.search.dm.dto.InputCatalogDto;
import com.finconsgroup.itserr.marketplace.search.dm.dto.InputFavouriteSearchDto;
import com.finconsgroup.itserr.marketplace.search.dm.dto.OutputCatalogDto;
import com.finconsgroup.itserr.marketplace.search.dm.dto.OutputCatalogFavouriteDto;
import com.finconsgroup.itserr.marketplace.search.dm.dto.OutputCatalogLocalSearchDto;
import com.finconsgroup.itserr.marketplace.search.dm.dto.OutputGlobalSearchAutoCompleteDto;
import com.finconsgroup.itserr.marketplace.search.dm.service.CatalogService;
import com.finconsgroup.itserr.marketplace.search.dm.util.SortUtils;
import java.beans.PropertyEditor;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.propertyeditors.StringTrimmerEditor;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;
import org.springframework.web.bind.WebDataBinder;
import org.springframework.web.bind.annotation.InitBinder;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class CatalogController
implements CatalogApi {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CatalogController.class);
    private final CatalogService catalogService;

    @InitBinder
    public void initBinder(WebDataBinder binder) {
        binder.registerCustomEditor(String.class, (PropertyEditor)new StringTrimmerEditor(false));
    }

    @NonNull
    public OutputCatalogDto upsertCatalog(String id, InputCatalogDto dto) {
        return (OutputCatalogDto)this.catalogService.upsertDocument((Object)dto);
    }

    @NonNull
    public OutputCatalogDto getCatalog(String id) {
        return (OutputCatalogDto)this.catalogService.getDocument(id);
    }

    public void deleteCatalog(String id) {
        this.catalogService.deleteDocument(id);
    }

    public void deleteAll() {
        this.catalogService.deleteAll();
    }

    @NonNull
    public List<OutputGlobalSearchAutoCompleteDto> getAutoCompletions(@NonNull String terms) {
        return this.catalogService.getAutoCompletions(terms);
    }

    @NonNull
    public Page<OutputCatalogLocalSearchDto> getLocalSearch(@Nullable String terms, @Nullable String filters, int pageNumber, int pageSize, String sort, Sort.Direction direction, String multiSort) {
        Sort sortToApply = SortUtils.buildSort((String)sort, (Sort.Direction)direction, (String)multiSort, (String)":", Map.of());
        PageRequest pageable = PageRequest.of((int)pageNumber, (int)pageSize, (Sort)sortToApply);
        return this.catalogService.getLocalSearch(terms, filters, (Pageable)pageable);
    }

    public Page<OutputCatalogFavouriteDto> getFavourite(InputFavouriteSearchDto dto, String filters, int pageNumber, int pageSize, String sort, Sort.Direction direction) {
        PageRequest pageable = PageRequest.of((int)pageNumber, (int)pageSize, (Sort)Sort.by((Sort.Direction)direction, (String[])new String[]{sort}));
        return this.catalogService.getFavourite(dto.getIds(), filters, (Pageable)pageable);
    }

    @Generated
    public CatalogController(CatalogService catalogService) {
        this.catalogService = catalogService;
    }
}

