/*
 * Decompiled with CFR 0.152.
 */
package com.finconsgroup.itserr.marketplace.search.dm.controller;

import com.finconsgroup.itserr.marketplace.search.dm.api.NewsApi;
import com.finconsgroup.itserr.marketplace.search.dm.dto.InputNewsDto;
import com.finconsgroup.itserr.marketplace.search.dm.dto.OutputGlobalSearchAutoCompleteDto;
import com.finconsgroup.itserr.marketplace.search.dm.dto.OutputNewsDto;
import com.finconsgroup.itserr.marketplace.search.dm.dto.OutputNewsLocalSearchDto;
import com.finconsgroup.itserr.marketplace.search.dm.service.NewsService;
import com.finconsgroup.itserr.marketplace.search.dm.util.SortUtils;
import java.beans.PropertyEditor;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.propertyeditors.StringTrimmerEditor;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;
import org.springframework.web.bind.WebDataBinder;
import org.springframework.web.bind.annotation.InitBinder;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class NewsController
implements NewsApi {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(NewsController.class);
    private final NewsService newsService;

    @InitBinder
    public void initBinder(WebDataBinder binder) {
        binder.registerCustomEditor(String.class, (PropertyEditor)new StringTrimmerEditor(false));
    }

    @NonNull
    public OutputNewsDto upsertNews(String id, InputNewsDto dto) {
        return (OutputNewsDto)this.newsService.upsertDocument((Object)dto);
    }

    @NonNull
    public OutputNewsDto getNews(String id) {
        return (OutputNewsDto)this.newsService.getDocument(id);
    }

    public void deleteNews(String id) {
        this.newsService.deleteDocument(id);
    }

    public void deleteAll() {
        this.newsService.deleteAll();
    }

    @NonNull
    public List<OutputGlobalSearchAutoCompleteDto> getAutoCompletions(@NonNull String terms) {
        return this.newsService.getAutoCompletions(terms);
    }

    @NonNull
    public Page<OutputNewsLocalSearchDto> getLocalSearch(@Nullable String terms, @Nullable String filters, int pageNumber, int pageSize, String sort, Sort.Direction direction, String multiSort) {
        Sort sortToApply = SortUtils.buildSort((String)sort, (Sort.Direction)direction, (String)multiSort, (String)":", Map.of());
        PageRequest pageable = PageRequest.of((int)pageNumber, (int)pageSize, (Sort)sortToApply);
        return this.newsService.getLocalSearch(terms, filters, (Pageable)pageable);
    }

    @Generated
    public NewsController(NewsService newsService) {
        this.newsService = newsService;
    }
}

