/*
 * Decompiled with CFR 0.152.
 */
package com.finconsgroup.itserr.marketplace.search.dm.opensearch;

import com.finconsgroup.itserr.marketplace.core.web.bean.QueryFilter;
import com.finconsgroup.itserr.marketplace.core.web.utils.FilterUtils;
import com.finconsgroup.itserr.marketplace.search.dm.bean.ContainsAnyTermsRequest;
import com.finconsgroup.itserr.marketplace.search.dm.bean.ContainsAnyTermsWithFiltersRequest;
import com.finconsgroup.itserr.marketplace.search.dm.bean.QueryRequest;
import com.finconsgroup.itserr.marketplace.search.dm.bean.TopHitsAggregationRequest;
import com.finconsgroup.itserr.marketplace.search.dm.entity.ScoredDocument;
import com.finconsgroup.itserr.marketplace.search.dm.opensearch.OpenSearchHelper;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.opensearch.client.json.JsonData;
import org.opensearch.client.opensearch._types.FieldValue;
import org.opensearch.client.opensearch._types.SortOptions;
import org.opensearch.client.opensearch._types.SortOrder;
import org.opensearch.client.opensearch._types.aggregations.Aggregate;
import org.opensearch.client.opensearch._types.query_dsl.BoolQuery;
import org.opensearch.client.opensearch._types.query_dsl.Query;
import org.opensearch.client.opensearch._types.query_dsl.RegexpQuery;
import org.opensearch.client.opensearch._types.query_dsl.TermQuery;
import org.opensearch.client.opensearch.core.SearchRequest;
import org.opensearch.client.opensearch.core.SearchResponse;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.data.core.OpenSearchOperations;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.data.elasticsearch.core.IndexOperations;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;
import org.springframework.stereotype.Component;

@Component
public class OpenSearchHelper {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(OpenSearchHelper.class);
    private static final String CONTAINS_WILDCARD_FORMAT = "*%s*^0.5 %s";
    private static final String TOP_HITS_AGGREGATION_FORMAT = "top_hits_%s";
    private static final String ID_FIELD_NAME = "_id";
    private static final Set<Character> WILDCARD_SPECIAL_CHARS = Set.of(Character.valueOf(':'), Character.valueOf('.'), Character.valueOf('?'), Character.valueOf('+'), Character.valueOf('*'), Character.valueOf('|'), Character.valueOf('{'), Character.valueOf('}'), Character.valueOf('['), Character.valueOf(']'), Character.valueOf('('), Character.valueOf(')'), Character.valueOf('\"'), Character.valueOf('\\'), Character.valueOf('@'), Character.valueOf('&'), Character.valueOf('~'), Character.valueOf('<'), Character.valueOf('>'));
    private static final Set<String> CASE_SENSITIVE_TYPES = Set.of("text", "keyword");
    private static final String REGEXP_SEPARATOR = "|";
    private final OpenSearchOperations openSearchOperations;
    private final Map<String, Map<String, String>> indexPropertyTypeMap = new LinkedHashMap();

    public <T> SearchRequest buildTopHitsSearchRequest(QueryRequest<T> queryRequest, int topHitsLimit, String[] indexNames) {
        Function queryFn = this.mapQueryRequestToQueryFn(queryRequest);
        return SearchRequest.of(r -> {
            r.index(Arrays.asList(indexNames)).query(queryFn);
            if (queryRequest.getSourceFields() != null) {
                r.source(s -> s.filter(sf -> sf.includes(queryRequest.getSourceFields())));
            }
            return r.size(Integer.valueOf(topHitsLimit));
        });
    }

    public <T> SearchRequest buildTopHitsByTermSearchRequest(QueryRequest<T> queryRequest, TopHitsAggregationRequest<T> aggregationRequest, String[] indexNames) {
        Function queryFn = this.mapQueryRequestToQueryFn(queryRequest);
        return SearchRequest.of(r -> r.index(Arrays.asList(indexNames)).query(queryFn).aggregations(aggregationRequest.name(), a -> a.terms(t -> t.field(aggregationRequest.term())).aggregations(TOP_HITS_AGGREGATION_FORMAT.formatted(aggregationRequest.name()), thq -> thq.topHits(tha -> tha.size(Integer.valueOf(aggregationRequest.topHitsLimit())).source(s -> s.filter(sf -> sf.includes(aggregationRequest.sourceFields())))))).size(Integer.valueOf(0)));
    }

    public <T> SearchRequest buildFindPageSearchRequest(QueryRequest<T> queryRequest, Pageable pageable, String[] indexNames) {
        Function queryFn = this.mapQueryRequestToQueryFn(queryRequest);
        return SearchRequest.of(r -> {
            r.index(Arrays.asList(indexNames)).query(queryFn);
            if (queryRequest.getSourceFields() != null) {
                r.source(s -> s.filter(sf -> sf.includes(queryRequest.getSourceFields())));
            }
            if (pageable.getSort().isSorted()) {
                List<SortOptions> sortOptionsList = pageable.getSort().stream().map(order -> SortOptions.of(s -> s.field(f -> f.field(order.getProperty()).order(order.getDirection().isAscending() ? SortOrder.Asc : SortOrder.Desc)))).toList();
                r.sort(sortOptionsList);
            }
            return r.from(Integer.valueOf(pageable.getPageSize() * pageable.getPageNumber())).size(Integer.valueOf(pageable.getPageSize()));
        });
    }

    public <T> List<T> mapTopHitsSearchResponse(SearchResponse<T> searchResponse, QueryRequest<T> request) {
        return searchResponse.hits().hits().stream().map(h -> {
            Object hitResult = h.source();
            if (request.includeScore() && hitResult instanceof ScoredDocument) {
                ScoredDocument scoredDocument = (ScoredDocument)hitResult;
                scoredDocument.setScore(h.score());
            }
            return hitResult;
        }).toList();
    }

    public <T> Map<String, List<T>> mapTopHitsByTermAggregateResponse(SearchResponse<T> searchResponse, TopHitsAggregationRequest<T> request) {
        LinkedHashMap topHitsByTerm = new LinkedHashMap();
        Aggregate termsAggregate = (Aggregate)searchResponse.aggregations().get(request.name());
        if (termsAggregate != null) {
            termsAggregate.sterms().buckets().array().forEach(b -> {
                Aggregate topHitsAggregate = (Aggregate)b.aggregations().get(TOP_HITS_AGGREGATION_FORMAT.formatted(request.name()));
                if (topHitsAggregate != null) {
                    LinkedList topHits = new LinkedList();
                    topHitsAggregate.topHits().hits().hits().forEach(d -> {
                        Object topHitResult = Objects.requireNonNull((JsonData)d.source()).to(request.documentClass());
                        if (request.includeScore() && topHitResult instanceof ScoredDocument) {
                            ScoredDocument scoredDocument = (ScoredDocument)topHitResult;
                            scoredDocument.setScore(d.score());
                        }
                        topHits.add(topHitResult);
                    });
                    topHitsByTerm.put(b.key(), topHits);
                }
            });
        }
        return topHitsByTerm;
    }

    public <T> Page<T> mapPageSearchResponse(SearchResponse<T> searchResponse, QueryRequest<T> request, Pageable pageable) {
        List<Object> content = searchResponse.hits().hits().stream().map(h -> {
            Object hitResult = h.source();
            if (request.includeScore() && hitResult instanceof ScoredDocument) {
                ScoredDocument scoredDocument = (ScoredDocument)hitResult;
                scoredDocument.setScore(h.score());
            }
            return hitResult;
        }).toList();
        return new PageImpl(content, pageable, searchResponse.hits().total().value());
    }

    public <T> Function<Query.Builder, ObjectBuilder<Query>> mapContainsAnyTermsRequestToQueryFn(ContainsAnyTermsRequest<T> request) {
        return q -> q.bool(b -> {
            this.applyContainsAnyTermsRequest(request, b);
            return b;
        });
    }

    public <T> Function<Query.Builder, ObjectBuilder<Query>> mapContainsAnyTermsWithFiltersRequestToQueryFn(ContainsAnyTermsWithFiltersRequest<T> request) {
        Map propertyTypeMap = this.getIndexPropertyTypeMap(request.getDocumentClass());
        return q -> q.bool(b -> {
            if (request.containsAnyTermsRequest() != null) {
                this.applyContainsAnyTermsRequest(request.containsAnyTermsRequest(), b);
            }
            if (request.ids() != null && !request.ids().isEmpty()) {
                List<FieldValue> fieldValues = request.ids().stream().map(String::trim).filter(StringUtils::isNotBlank).map(FieldValue::of).toList();
                b.must(m -> m.terms(t -> t.field(ID_FIELD_NAME).terms(tf -> tf.value(fieldValues))));
            }
            this.applyQueryFilters(request.queryFilters(), b, request.nestedPaths(), propertyTypeMap);
            return b;
        });
    }

    private void processMappingProperties(String path, Map<String, Object> mappings, Map<String, String> propertyTypes) {
        mappings.forEach((key, value) -> {
            if ("type".equals(key) && value instanceof String) {
                String strValue = (String)value;
                propertyTypes.put(path, strValue);
            } else if (value instanceof Map) {
                Object newPath = "properties".equals(key) || "fields".equals(key) ? path : (path == null ? key : path + "." + key);
                this.processMappingProperties((String)newPath, (Map)value, propertyTypes);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, String> getIndexPropertyTypeMap(Class<?> documentClass) {
        try {
            Map map = this.indexPropertyTypeMap;
            synchronized (map) {
                if (!this.indexPropertyTypeMap.containsKey(documentClass.getSimpleName())) {
                    IndexOperations indexOperations = this.openSearchOperations.indexOps(documentClass);
                    Map mappings = indexOperations.getMapping();
                    LinkedHashMap propertyTypes = new LinkedHashMap();
                    this.processMappingProperties(null, mappings, propertyTypes);
                    this.indexPropertyTypeMap.put(documentClass.getSimpleName(), Map.copyOf(propertyTypes));
                }
                return (Map)this.indexPropertyTypeMap.get(documentClass.getSimpleName());
            }
        }
        catch (Exception e) {
            log.error("Error while getting index property type map", (Throwable)e);
            return Map.of();
        }
    }

    private <T> void applyContainsAnyTermsRequest(@NonNull ContainsAnyTermsRequest<T> request, @NonNull BoolQuery.Builder b) {
        List<String> termsList = Stream.of(request.terms().trim().split(" ")).map(String::trim).filter(s -> !s.isEmpty()).toList();
        String fullTextSearchValue = request.useWildcard() ? termsList.stream().map(s -> {
            if (request.useWildcard()) {
                String escapedStr = this.escapeWildcardSpecialChars(s);
                return CONTAINS_WILDCARD_FORMAT.formatted(escapedStr, s);
            }
            return s;
        }).collect(Collectors.joining(" ")) : request.terms();
        String regexpValue = this.buildRegexpValue(Stream.concat(Stream.of(request.terms()), termsList.stream()));
        request.searchFields().forEach(sf -> {
            if ("text".equals(sf.fieldType())) {
                Map fieldNamesByNestedPath = this.findNestedFields(sf.fieldNames(), request.nestedPaths());
                if (fieldNamesByNestedPath.size() > 1) {
                    b.should(m -> m.bool(fb -> {
                        fieldNamesByNestedPath.forEach((nestedPath, fieldNames) -> fb.should(fbq -> this.applyNestedPath(fbq, nestedPath, qb -> qb.queryString(qs -> qs.allowLeadingWildcard(Boolean.valueOf(request.useWildcard())).fields(fieldNames).query(fullTextSearchValue)))).minimumShouldMatch("1"));
                        return fb;
                    }));
                } else {
                    b.should(m -> {
                        fieldNamesByNestedPath.forEach((nestedPath, fieldNames) -> this.applyNestedPath(m, nestedPath, qb -> qb.queryString(qs -> qs.allowLeadingWildcard(Boolean.valueOf(request.useWildcard())).fields(fieldNames).query(fullTextSearchValue))));
                        return m;
                    });
                }
            } else if ("keyword".equals(sf.fieldType())) {
                sf.fieldNames().forEach(fn -> b.should(m -> this.applyNestedPath(m, this.findNestedPath(fn, request.nestedPaths()), qb -> qb.regexp(t -> t.field(fn).value(regexpValue).caseInsensitive(Boolean.valueOf(true))))));
            }
        });
        b.minimumShouldMatch("1");
    }

    private String buildRegexpValue(Stream<String> terms) {
        return terms.map(arg_0 -> this.escapeWildcardSpecialChars(arg_0)).collect(Collectors.joining(REGEXP_SEPARATOR));
    }

    private Map<String, List<String>> findNestedFields(List<String> fieldNames, Set<String> nestedPaths) {
        if (nestedPaths == null || nestedPaths.isEmpty()) {
            return Map.of("", fieldNames);
        }
        LinkedHashMap<String, List<String>> fieldNamesByNestedPath = new LinkedHashMap<String, List<String>>();
        for (String fieldName : fieldNames) {
            String key = this.findNestedPath(fieldName, nestedPaths);
            fieldNamesByNestedPath.computeIfAbsent(key, k -> new LinkedList()).add(fieldName);
        }
        return fieldNamesByNestedPath;
    }

    private String findNestedPath(String fieldName, Set<String> nestedPaths) {
        if (nestedPaths == null || nestedPaths.isEmpty()) {
            return "";
        }
        return nestedPaths.stream().filter(fieldName::startsWith).findFirst().orElse("");
    }

    private void applyQueryFilters(@Nullable List<QueryFilter> queryFilters, @NonNull BoolQuery.Builder b, Set<String> nestedPaths, Map<String, String> propertyTypeMap) {
        if (queryFilters == null || queryFilters.isEmpty()) {
            return;
        }
        Map<String, List<QueryFilter>> rangeFiltersByField = queryFilters.stream().filter(qf -> FilterUtils.RANGE_FILTER_OPERATORS.contains(qf.operator())).collect(Collectors.groupingBy(QueryFilter::fieldName));
        queryFilters.stream().filter(qf -> !FilterUtils.RANGE_FILTER_OPERATORS.contains(qf.operator())).forEach(qf -> b.filter(f -> this.applyEQFilter(qf, f, nestedPaths, propertyTypeMap)));
        rangeFiltersByField.forEach((fieldName, rangeFilters) -> b.filter(f -> this.applyRangeFilters(fieldName, f, nestedPaths, rangeFilters)));
    }

    private Query.Builder applyEQFilter(QueryFilter qf, Query.Builder f, Set<String> nestedPaths, Map<String, String> propertyTypeMap) {
        if (qf.filterValues().size() > 1) {
            String regexpValue = this.buildRegexpValue(qf.filterValues().stream());
            this.applyNestedPath(f, this.findNestedPath(qf.fieldName(), nestedPaths), qb -> qb.regexp(t -> this.applyRegexpCaseInsensitiveFilter(t.field(qf.fieldName()).value(regexpValue), qf, propertyTypeMap)));
        } else {
            this.applyNestedPath(f, this.findNestedPath(qf.fieldName(), nestedPaths), qb -> qb.term(t -> this.applyTermCaseInsensitiveFilter(t.field(qf.fieldName()).value(FieldValue.of((String)((String)qf.filterValues().getFirst()))), qf, propertyTypeMap)));
        }
        return f;
    }

    private Query.Builder applyRangeFilters(String fieldName, Query.Builder f, Set<String> nestedPaths, List<QueryFilter> rangeFilters) {
        this.applyNestedPath(f, this.findNestedPath(fieldName, nestedPaths), qb -> qb.range(r -> {
            r.field(fieldName);
            rangeFilters.forEach(rf -> {
                JsonData value = JsonData.of((Object)((String)rf.filterValues().getFirst()));
                switch (1.$SwitchMap$com$finconsgroup$itserr$marketplace$core$web$enums$FilterOperator[rf.operator().ordinal()]) {
                    case 1: {
                        r.gt(value);
                        break;
                    }
                    case 2: {
                        r.gte(value);
                        break;
                    }
                    case 3: {
                        r.lt(value);
                        break;
                    }
                    case 4: {
                        r.lte(value);
                    }
                }
            });
            return r;
        }));
        return f;
    }

    private TermQuery.Builder applyTermCaseInsensitiveFilter(TermQuery.Builder termQueryBuilder, QueryFilter queryFilter, Map<String, String> propertyTypeMap) {
        if (propertyTypeMap == null) {
            return termQueryBuilder;
        }
        String type = propertyTypeMap.get(queryFilter.fieldName());
        if (type != null && CASE_SENSITIVE_TYPES.contains(type)) {
            return termQueryBuilder.caseInsensitive(Boolean.TRUE);
        }
        return termQueryBuilder;
    }

    private RegexpQuery.Builder applyRegexpCaseInsensitiveFilter(RegexpQuery.Builder regexpQueryBuilder, QueryFilter queryFilter, Map<String, String> propertyTypeMap) {
        if (propertyTypeMap == null) {
            return regexpQueryBuilder;
        }
        String type = propertyTypeMap.get(queryFilter.fieldName());
        if (type != null && CASE_SENSITIVE_TYPES.contains(type)) {
            return regexpQueryBuilder.caseInsensitive(Boolean.TRUE);
        }
        return regexpQueryBuilder;
    }

    private ObjectBuilder<Query> applyNestedPath(@NonNull Query.Builder queryBuilder, String nestedPath, @NonNull Function<Query.Builder, ObjectBuilder<Query>> fn) {
        if (StringUtils.isNotBlank((CharSequence)nestedPath)) {
            return queryBuilder.nested(n -> n.path(nestedPath).query(fn));
        }
        return fn.apply(queryBuilder);
    }

    public <T> Function<Query.Builder, ObjectBuilder<Query>> mapQueryRequestToQueryFn(QueryRequest<T> request) {
        if (request instanceof ContainsAnyTermsRequest) {
            ContainsAnyTermsRequest containsAnyTermsRequest = (ContainsAnyTermsRequest)request;
            return this.mapContainsAnyTermsRequestToQueryFn(containsAnyTermsRequest);
        }
        if (request instanceof ContainsAnyTermsWithFiltersRequest) {
            ContainsAnyTermsWithFiltersRequest containsAnyTermsWithFiltersRequest = (ContainsAnyTermsWithFiltersRequest)request;
            return this.mapContainsAnyTermsWithFiltersRequestToQueryFn(containsAnyTermsWithFiltersRequest);
        }
        throw new IllegalArgumentException("Unknown OpenSearchQueryRequest");
    }

    private String escapeWildcardSpecialChars(String s) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (WILDCARD_SPECIAL_CHARS.contains(Character.valueOf(c))) {
                sb.append('\\');
            }
            sb.append(c);
        }
        return sb.toString();
    }

    @Generated
    public OpenSearchHelper(OpenSearchOperations openSearchOperations) {
        this.openSearchOperations = openSearchOperations;
    }
}

