package com.finconsgroup.itserr.marketplace.search.dm.dto;

import io.swagger.v3.oas.annotations.media.Schema;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;

/**
 * It represents the payload for catalog item metadata set.
 */
@Schema(name = "CatalogMetadataSetDto",
        description = "Represents the payload for catalog item metadata set")
@Data
@Builder
@AllArgsConstructor
public class CatalogMetadataSetDto {

    @Schema(description = "Metadata id", example = "f81d4fae-7dec-11d0-a765-00a0c91e6bf6")
    private String id;

    @Schema(description = "Metadata name", example = "Dublin Core (DC)")
    private String name;

    @Schema(description = "Metadata description", example = "Standard metadata for digital resources.")
    private String description;

    @Schema(description = "True if metadata is a standard one, false otherwise.", example = "true")
    private boolean standard;

}
