package com.finconsgroup.itserr.marketplace.search.dm.dto;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * It represents the persistent structure of copyright field of Institutional Page for both Global and Local search.
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
@Builder
@JsonIgnoreProperties(ignoreUnknown = true)
public class InstitutionalPageCopyrightDto {

    @Schema(description = "Copyright text to display", example = "Example Corp. All rights reserved")
    private String text;

    @Schema(description = "Copyright year", example = "2025")
    private Integer year;
}
