/*
 * Decompiled with CFR 0.152.
 */
package com.finconsgroup.itserr.marketplace.search.dm.converter;

import java.time.Instant;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import org.springframework.data.elasticsearch.core.mapping.PropertyValueConverter;
import org.springframework.lang.NonNull;

public class InstantPropertyValueConverter
implements PropertyValueConverter {
    private static final DateTimeFormatter FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss[.SSSSSS]'Z'").withZone(ZoneId.of("UTC"));

    @NonNull
    public Object read(@NonNull Object value) {
        if (value instanceof String) {
            String strValue = (String)value;
            return Instant.parse(strValue);
        }
        return Instant.parse(value.toString());
    }

    @NonNull
    public Object write(@NonNull Object value) {
        if (value instanceof Instant) {
            Instant instant = (Instant)value;
            return FORMATTER.format(instant);
        }
        return value.toString();
    }
}

