/*
 * Decompiled with CFR 0.152.
 */
package com.finconsgroup.itserr.marketplace.search.dm.repository.impl;

import com.finconsgroup.itserr.marketplace.core.web.exception.WP2ExecutionException;
import com.finconsgroup.itserr.marketplace.search.dm.bean.QueryRequest;
import com.finconsgroup.itserr.marketplace.search.dm.bean.TopHitsAggregationRequest;
import com.finconsgroup.itserr.marketplace.search.dm.opensearch.OpenSearchHelper;
import com.finconsgroup.itserr.marketplace.search.dm.repository.CustomAggregationRepository;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.opensearch.client.opensearch.OpenSearchClient;
import org.opensearch.client.opensearch.core.SearchRequest;
import org.opensearch.client.opensearch.core.SearchResponse;
import org.opensearch.data.core.OpenSearchOperations;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class CustomAggregationRepositoryOpenSearchImpl
implements CustomAggregationRepository {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CustomAggregationRepositoryOpenSearchImpl.class);
    private final OpenSearchClient openSearchClient;
    private final OpenSearchHelper openSearchHelper;
    private final OpenSearchOperations openSearchOperations;

    public <T> Map<String, List<T>> findTopHitsForQueryByTerm(QueryRequest<T> queryRequest, TopHitsAggregationRequest<T> aggregationRequest) {
        String[] indexNames = this.openSearchOperations.getIndexCoordinatesFor(queryRequest.getDocumentClass()).getIndexNames();
        SearchRequest searchRequest = this.openSearchHelper.buildTopHitsByTermSearchRequest(queryRequest, aggregationRequest, indexNames);
        try {
            SearchResponse searchResponse = this.openSearchClient.search(searchRequest, queryRequest.getDocumentClass());
            return this.openSearchHelper.mapTopHitsByTermAggregateResponse(searchResponse, aggregationRequest);
        }
        catch (IOException e) {
            throw new WP2ExecutionException((Throwable)e);
        }
    }

    @Generated
    public CustomAggregationRepositoryOpenSearchImpl(OpenSearchClient openSearchClient, OpenSearchHelper openSearchHelper, OpenSearchOperations openSearchOperations) {
        this.openSearchClient = openSearchClient;
        this.openSearchHelper = openSearchHelper;
        this.openSearchOperations = openSearchOperations;
    }
}

