package com.finconsgroup.itserr.marketplace.search.dm.bean;

import lombok.Builder;

import java.util.List;
import java.util.Set;

/**
 * The request to filter by terms optionally using wildcard in the provided search fields.
 *
 * @param documentClass the class representing the type of the documents to search for
 * @param terms         the terms to search for
 * @param sourceFields  the source fields to fetch
 * @param nestedPaths   the set of paths of nested type
 * @param searchFields  the fields to search in
 * @param useWildcard   flag to indicate if wildcard should be used for each term
 * @param includeScore  flag to indicate if score should be included in search result
 */
@Builder
public record ContainsAnyTermsRequest<T>(
    Class<T> documentClass,
    String terms,
    List<String> sourceFields,
    Set<String> nestedPaths,
    List<QuerySearchFields> searchFields,
    boolean useWildcard,
    boolean includeScore) implements QueryRequest<T> {

    @Override
    public Class<T> getDocumentClass() {
        return documentClass;
    }

    @Override
    public List<String> getSourceFields() {
        return sourceFields;
    }

    @Override
    public boolean includeScore() {
        return includeScore;
    }

    @Override
    public boolean useWildcard() {
        return useWildcard;
    }
}
