package com.finconsgroup.itserr.marketplace.search.dm.dto;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.List;

/**
 * It represents the persistent structure of paragraph field of Institutional Page for both Global and Local search.
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
@Builder
@JsonIgnoreProperties(ignoreUnknown = true)
public class InstitutionalPageParagraphDto {

    @Schema(description = "ID of the paragraph", example = "11111111-aaaa-0000-0000-000000000000")
    private String id;

    @Schema(description = "The title of the paragraph", example = "Outcomes")
    private String title;

    @Schema(description = "The content of the paragraph", example = "A shared library of reusable software components")
    private String content;

    @Schema(description = "The image url of the paragraph", example = "https://picsum.photos/200")
    private String imageUrl;

    @Schema(description = "The resource url of the paragraph", example = "https://www.example.com/")
    private String resourceUrl;

    @Schema(description = "list of labels related to the paragraph", example = "[\"god\",\"marriage\"]")
    private List<String> labels;
}
