package com.finconsgroup.itserr.marketplace.search.dm.mapper;

import com.finconsgroup.itserr.marketplace.search.dm.dto.InputCatalogDto;
import com.finconsgroup.itserr.marketplace.search.dm.dto.OutputCatalogDto;
import com.finconsgroup.itserr.marketplace.search.dm.dto.OutputCatalogFavouriteDto;
import com.finconsgroup.itserr.marketplace.search.dm.dto.OutputCatalogLocalSearchDto;
import com.finconsgroup.itserr.marketplace.search.dm.dto.OutputGlobalSearchAutoCompleteDataDto;
import com.finconsgroup.itserr.marketplace.search.dm.dto.OutputGlobalSearchDataDto;
import com.finconsgroup.itserr.marketplace.search.dm.entity.Catalog;
import org.mapstruct.Mapper;
import org.mapstruct.Mapping;

/**
 * Mapper for all dto/entity conversions related to {@link Catalog}
 */
@Mapper(config = MapperConfiguration.class)
public interface CatalogMapper {

    @Mapping(target = "score", ignore = true)
    Catalog toEntity(InputCatalogDto dto);

    OutputCatalogDto toDto(Catalog entity);

    OutputGlobalSearchAutoCompleteDataDto toAutoCompleteDataDto(Catalog entity);

    OutputCatalogLocalSearchDto toLocalSearchDto(Catalog entity);

    @Mapping(target = "publicationDate", source = "publication.date")
    OutputCatalogFavouriteDto toFavouriteDto(Catalog entity);

    OutputGlobalSearchDataDto toGlobalSearchDataDto(Catalog entity);

}
