/*
 * Decompiled with CFR 0.152.
 */
package com.finconsgroup.itserr.marketplace.search.dm.api;

import com.finconsgroup.itserr.marketplace.core.web.validation.annotation.ValidPutIdParameters;
import com.finconsgroup.itserr.marketplace.core.web.validation.annotation.ValidQueryFilter;
import com.finconsgroup.itserr.marketplace.search.dm.dto.InputDiscussionDto;
import com.finconsgroup.itserr.marketplace.search.dm.dto.OutputDiscussionDto;
import com.finconsgroup.itserr.marketplace.search.dm.dto.OutputDiscussionLocalSearchDto;
import com.finconsgroup.itserr.marketplace.search.dm.dto.OutputGlobalSearchAutoCompleteDto;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Positive;
import jakarta.validation.constraints.PositiveOrZero;
import jakarta.validation.constraints.Size;
import java.util.List;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Sort;
import org.springframework.http.HttpStatus;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseStatus;

@Tag(name="Discussion", description="Operations related to discussion search")
@Validated
@SecurityRequirement(name="BearerAuth")
@ApiResponses(value={@ApiResponse(responseCode="500", ref="InternalServerError")})
public interface DiscussionApi {
    @Operation(summary="Create/Update document in Discussion Search index", description="Create a new document or update an existing document entry in the Discussion Search index using the provided dto. It also performs validations and returns errors in case of validation failures")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="400", ref="BadRequest")})
    @ResponseStatus(value=HttpStatus.OK)
    @PutMapping(value={"/discussion/{id}"}, produces={"application/json"}, consumes={"application/json"})
    @ValidPutIdParameters
    public OutputDiscussionDto upsertDiscussion(@PathVariable(value="id") String var1, @Valid @RequestBody InputDiscussionDto var2);

    @Operation(summary="Fetches document from Discussion Search index", description="Fetches a document entry in the Discussion Search index using the provided id.It returns not found response in case if the id does not exist")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="404", ref="NotFound")})
    @GetMapping(value={"/discussion/{id}"}, produces={"application/json"})
    @ResponseStatus(value=HttpStatus.OK)
    public OutputDiscussionDto getDiscussion(@PathVariable(value="id") String var1);

    @Operation(summary="Deletes document from Discussion Search index", description="Deletes a document entry in the Discussion Search index using the provided id.It returns not found response in case if the id does not exist")
    @ApiResponses(value={@ApiResponse(responseCode="204", description="No Content"), @ApiResponse(responseCode="404", ref="NotFound")})
    @DeleteMapping(value={"/discussion/{id}"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void deleteDiscussion(@PathVariable(value="id") String var1);

    @Operation(summary="Deletes all the documents from Discussion Search index", description="Deletes all the documents in the Discussion Search index.", hidden=true)
    @ApiResponses(value={@ApiResponse(responseCode="204", description="No Content")})
    @DeleteMapping(value={"/discussion-all"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void deleteAll();

    @Operation(summary="Perform discussion search for autocompletion and retrieve the results", description="Perform discussion search for autocompletion based on the terms provided and retrieve results")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="400", ref="BadRequest")})
    @ResponseStatus(value=HttpStatus.OK)
    @GetMapping(value={"/discussion/auto-complete"}, produces={"application/json"})
    public List<OutputGlobalSearchAutoCompleteDto> getAutoCompletions(@NotNull @Size(min=3) @RequestParam(value="terms") @NotNull @Size(min=3) String var1);

    @Operation(summary="Perform discussion local search and retrieve the results", description="Perform the discussion local search based on the terms and filters provided and retrieve results", parameters={@Parameter(name="terms", description="The terms to search for"), @Parameter(name="filters", description="The additional filters to apply in the format key1=value1,value2&key2=value3,value4"), @Parameter(name="pageNumber", description="The page index, starting from 0"), @Parameter(name="pageSize", description="The number of items per page"), @Parameter(name="sort", description="The field by which to sort the results"), @Parameter(name="direction", description="The sorting direction: ASC or DESC"), @Parameter(name="multiSort", description="The multiple fields to sort by, takes preference over sort in the format field1,field2:desc,field3")})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="400", ref="BadRequest")})
    @ResponseStatus(value=HttpStatus.OK)
    @GetMapping(value={"/discussion/search"}, produces={"application/json"})
    public Page<OutputDiscussionLocalSearchDto> getLocalSearch(@Size(min=3) @RequestParam(value="terms", required=false) @Size(min=3) String var1, @RequestParam(value="filters", required=false) @ValidQueryFilter(configKey="discussion") String var2, @RequestParam(name="pageNumber", defaultValue="0", required=false) @PositiveOrZero int var3, @RequestParam(name="pageSize", defaultValue="10", required=false) @Positive int var4, @RequestParam(name="sort", defaultValue="relevance", required=false) String var5, @RequestParam(name="direction", defaultValue="DESC", required=false) Sort.Direction var6, @RequestParam(name="multiSort", defaultValue="", required=false) String var7);
}

