/*
 * Decompiled with CFR 0.152.
 */
package com.finconsgroup.itserr.marketplace.search.dm.controller;

import com.finconsgroup.itserr.marketplace.search.dm.api.UserProfileApi;
import com.finconsgroup.itserr.marketplace.search.dm.dto.InputUserProfileDto;
import com.finconsgroup.itserr.marketplace.search.dm.dto.OutputGlobalSearchAutoCompleteDto;
import com.finconsgroup.itserr.marketplace.search.dm.dto.OutputUserProfileDto;
import com.finconsgroup.itserr.marketplace.search.dm.dto.OutputUserProfileLocalSearchDto;
import com.finconsgroup.itserr.marketplace.search.dm.service.UserProfileService;
import com.finconsgroup.itserr.marketplace.search.dm.util.SortUtils;
import java.beans.PropertyEditor;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.propertyeditors.StringTrimmerEditor;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;
import org.springframework.web.bind.WebDataBinder;
import org.springframework.web.bind.annotation.InitBinder;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class UserProfileController
implements UserProfileApi {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(UserProfileController.class);
    private final UserProfileService userProfileService;

    @InitBinder
    public void initBinder(WebDataBinder binder) {
        binder.registerCustomEditor(String.class, (PropertyEditor)new StringTrimmerEditor(false));
    }

    @NonNull
    public OutputUserProfileDto upsertUserProfile(String id, InputUserProfileDto dto) {
        return (OutputUserProfileDto)this.userProfileService.upsertDocument((Object)dto);
    }

    @NonNull
    public OutputUserProfileDto getUserProfile(String id) {
        return (OutputUserProfileDto)this.userProfileService.getDocument(id);
    }

    public void deleteUserProfile(String id) {
        this.userProfileService.deleteDocument(id);
    }

    public void deleteAll() {
        this.userProfileService.deleteAll();
    }

    @NonNull
    public List<OutputGlobalSearchAutoCompleteDto> getAutoCompletions(@NonNull String terms) {
        return this.userProfileService.getAutoCompletions(terms);
    }

    @NonNull
    public Page<OutputUserProfileLocalSearchDto> getLocalSearch(@Nullable String terms, @Nullable String filters, int pageNumber, int pageSize, String sort, Sort.Direction direction, String multiSort) {
        Sort sortToApply = SortUtils.buildSort((String)sort, (Sort.Direction)direction, (String)multiSort, (String)":", Map.of());
        PageRequest pageable = PageRequest.of((int)pageNumber, (int)pageSize, (Sort)sortToApply);
        return this.userProfileService.getLocalSearch(terms, filters, (Pageable)pageable);
    }

    @Generated
    public UserProfileController(UserProfileService userProfileService) {
        this.userProfileService = userProfileService;
    }
}

