package com.finconsgroup.itserr.marketplace.search.dm.dto;

import io.swagger.v3.oas.annotations.media.Schema;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;

/**
 * DTO for an endorsement.
 */
@Schema(name = "EndorsementDto", description = "DTO representing an endorsement")
@Data
@Builder
@AllArgsConstructor
public class EndorsementDto {

    @Schema(description = "Unique identifier of the user providing the endorsement", example = "550e8400-e29b-41d4-a716-446655440001")
    private String endorserId;

    @Schema(description = "First name of the user", example = "John")
    private String firstName;

    @Schema(description = "Last name of the user", example = "Doe")
    private String lastName;

    @Schema(description = "preferred Username of the user", example = "john.doe.213213")
    private String preferredUsername;

    @Schema(description = "Email address of the user", example = "john.doe@example.com")
    private String email;

    @Schema(description = "Link of the image of user", example = "https://imageLink")
    private String imageUrl;

    @Schema(description = "Short biography of the user", example = "Ricercatore Legge 210/10 a tempo indeterminato")
    private String shortBio;

}
