package com.finconsgroup.itserr.marketplace.search.dm.mapper.impl;

import com.finconsgroup.itserr.marketplace.search.dm.dto.OutputEventLocalSearchDto;
import com.finconsgroup.itserr.marketplace.search.dm.entity.Event;
import com.finconsgroup.itserr.marketplace.search.dm.mapper.EventMapper;
import com.finconsgroup.itserr.marketplace.search.dm.mapper.UserContextAwareMapper;
import lombok.RequiredArgsConstructor;
import org.springframework.lang.NonNull;

import java.util.UUID;

@RequiredArgsConstructor
public class EventUserContextAwareMapper implements UserContextAwareMapper<Event, OutputEventLocalSearchDto> {

    private final UUID userId;
    private final EventMapper eventMapper;

    @Override
    @NonNull
    public OutputEventLocalSearchDto toLocalSearchDto(@NonNull Event entity) {
        OutputEventLocalSearchDto dto = eventMapper.toLocalSearchDto(entity);
        if (userId == null) {
            return dto;
        }

        dto.setSubscribed(eventMapper.isSubscribed(entity, userId));
        return dto;
    }
}