/*
 * Decompiled with CFR 0.152.
 */
package com.finconsgroup.itserr.marketplace.search.dm.mapper;

import com.finconsgroup.itserr.marketplace.search.dm.dto.InputEventDto;
import com.finconsgroup.itserr.marketplace.search.dm.dto.OutputEventDto;
import com.finconsgroup.itserr.marketplace.search.dm.dto.OutputEventLocalSearchDto;
import com.finconsgroup.itserr.marketplace.search.dm.dto.OutputGlobalSearchAutoCompleteDataDto;
import com.finconsgroup.itserr.marketplace.search.dm.dto.OutputGlobalSearchDataDto;
import com.finconsgroup.itserr.marketplace.search.dm.entity.Event;
import com.finconsgroup.itserr.marketplace.search.dm.mapper.MapperConfiguration;
import com.finconsgroup.itserr.marketplace.search.dm.mapper.UserProfileMapper;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import org.mapstruct.Mapper;
import org.mapstruct.Mapping;
import org.mapstruct.Mappings;
import org.springframework.lang.NonNull;

@Mapper(config=MapperConfiguration.class, uses={UserProfileMapper.class})
public interface EventMapper {
    @Mapping(target="score", ignore=true)
    public Event toEntity(InputEventDto var1);

    public OutputEventDto toDto(Event var1);

    public OutputGlobalSearchAutoCompleteDataDto toAutoCompleteDataDto(Event var1);

    @Mapping(target="subscribed", ignore=true)
    public OutputEventLocalSearchDto toLocalSearchDto(Event var1);

    @Mappings(value={@Mapping(target="description", source="content"), @Mapping(target="imageUrl", source="image.url")})
    public OutputGlobalSearchDataDto toGlobalSearchDataDto(Event var1);

    default public boolean isSubscribed(@NonNull Event entity, UUID userId) {
        if (userId == null) {
            return false;
        }
        String userIdStr = userId.toString();
        return Optional.ofNullable(entity.getSubscribedParticipants()).orElse(List.of()).stream().map(Event.SubscribedParticipant::getUserId).anyMatch(userIdStr::equals);
    }
}

