/*
 * Decompiled with CFR 0.152.
 */
package com.finconsgroup.itserr.marketplace.search.dm.service.impl;

import com.finconsgroup.itserr.marketplace.core.web.exception.WP2ExecutionException;
import com.finconsgroup.itserr.marketplace.search.dm.dto.OutputGlobalSearchAutoCompleteDto;
import com.finconsgroup.itserr.marketplace.search.dm.dto.OutputGlobalSearchDto;
import com.finconsgroup.itserr.marketplace.search.dm.service.CatalogService;
import com.finconsgroup.itserr.marketplace.search.dm.service.DiscussionService;
import com.finconsgroup.itserr.marketplace.search.dm.service.EventService;
import com.finconsgroup.itserr.marketplace.search.dm.service.GlobalSearchService;
import com.finconsgroup.itserr.marketplace.search.dm.service.InstitutionalPageService;
import com.finconsgroup.itserr.marketplace.search.dm.service.NewsService;
import com.finconsgroup.itserr.marketplace.search.dm.service.SearchService;
import com.finconsgroup.itserr.marketplace.search.dm.service.UserProfileService;
import jakarta.annotation.PreDestroy;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.function.Function;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.lang.NonNull;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class DefaultGlobalSearchService
implements GlobalSearchService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DefaultGlobalSearchService.class);
    private final List<SearchService<?, ?>> searchServices;
    private final ExecutorService executor;

    public DefaultGlobalSearchService(CatalogService catalogService, UserProfileService userProfileService, InstitutionalPageService institutionalPageService, EventService eventService, NewsService newsService, DiscussionService discussionService) {
        this.searchServices = List.of(catalogService, userProfileService, institutionalPageService, eventService, newsService, discussionService);
        this.executor = Executors.newVirtualThreadPerTaskExecutor();
    }

    @NonNull
    @Transactional(readOnly=true)
    public List<OutputGlobalSearchAutoCompleteDto> getAutoCompletions(@NonNull String terms) {
        ArrayList<Function<String, List>> operations = new ArrayList<Function<String, List>>(this.searchServices.size());
        for (SearchService searchService : this.searchServices) {
            operations.add(arg_0 -> ((SearchService)searchService).getAutoCompletions(arg_0));
        }
        return this.performOperations(operations, terms);
    }

    @NonNull
    @Transactional(readOnly=true)
    public List<OutputGlobalSearchDto> getSearch(@NonNull String terms) {
        ArrayList<Function<String, List>> operations = new ArrayList<Function<String, List>>(this.searchServices.size());
        for (SearchService searchService : this.searchServices) {
            operations.add(arg_0 -> ((SearchService)searchService).getSearch(arg_0));
        }
        return this.performOperations(operations, terms);
    }

    @PreDestroy
    void close() {
        this.executor.shutdown();
    }

    private <T> List<T> performOperations(List<Function<String, List<T>>> operations, String input) {
        ArrayList resultList = new ArrayList();
        ArrayList<Future<List>> resultFutures = new ArrayList<Future<List>>(this.searchServices.size());
        for (Function<String, List<T>> function : operations) {
            Future<List> resultFuture = this.executor.submit(() -> (List)operation.apply(input));
            resultFutures.add(resultFuture);
        }
        for (Future future : resultFutures) {
            try {
                resultList.addAll((Collection)future.get());
            }
            catch (ExecutionException e) {
                throw new WP2ExecutionException(e.getCause());
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new WP2ExecutionException((Throwable)e);
            }
        }
        return resultList;
    }
}

