package com.finconsgroup.itserr.marketplace.userprofile.bs.api;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import io.swagger.v3.oas.annotations.tags.Tag;
import org.springframework.core.io.Resource;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestParam;

/**
 * This interface defines the contract for REST API endpoints used for system testing and debugging.
 *
 * <p>
 * These endpoints are intended for internal use only and
 * provide endpoints used for debugging and runtime analysis.
 * </p>
 *
 * <p>Example usage:
 * <pre>
 * GET /api/v1/bs/user-profile/diagnostics/download-logs - Download application log for analysis
 * </pre>
 * </p>
 */
@Tag(
        name = "Diagnostics",
        description = "Diagnostics API: provides endpoints used for " +
                "debugging and runtime analysis."
)
@SecurityRequirement(name = "BearerAuth")
public interface DiagnosticsApi {

    @Operation(
            summary = "Download log file",
            responses = {@ApiResponse(responseCode = "200", description = "OK"),}
    )
    @GetMapping(path = "/user-profile/diagnostics/download-logs", produces = MediaType.APPLICATION_OCTET_STREAM_VALUE)
    ResponseEntity<Resource> downloadLogs();

    /**
     * Test API method for sending a message about a user profile event.
     * Used to simulate or trigger the messaging logic for item creation, update, or deletion.
     *
     * @param isCreated true if the item was created
     * @param isUpdated true if the item was updated
     * @param isDeleted true if the item was deleted
     * @param name      the name of the user profile
     * @return a String representing the result of the operation
     */
    @Operation(
            summary = "Test method to send user profile message",
            responses = {@ApiResponse(responseCode = "200", description = "OK"),}
    )
    @GetMapping(path = "/user-profile/diagnostics/publish-message", produces = MediaType.APPLICATION_JSON_VALUE)
    ResponseEntity<String> publishMessage(
            @RequestParam(name = "isCreated", required = false, defaultValue = "false") boolean isCreated,
            @RequestParam(name = "isUpdated", required = false, defaultValue = "false") boolean isUpdated,
            @RequestParam(name = "isDeleted", required = false, defaultValue = "false") boolean isDeleted,
            @RequestParam(name = "name", required = false, defaultValue = "item name") String name
    );
}
