package com.finconsgroup.itserr.marketplace.userprofile.bs.bean;

import com.finconsgroup.itserr.marketplace.userprofile.bs.enums.MessagingEventType;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import org.springframework.context.ApplicationEvent;
import org.springframework.lang.NonNull;

import java.time.Instant;

/**
 * Application event when a resource matching users interests has been created.
 */
@Getter
@EqualsAndHashCode(callSuper = true)
public class UserProfileInterestsApplicationEvent extends ApplicationEvent {
    private final MessagingEventType eventType;
    private final Instant eventTimestamp;

    public UserProfileInterestsApplicationEvent(@NonNull UserProfileInterests source,
                                                @NonNull MessagingEventType eventType) {
        super(source);
        this.eventType = eventType;
        this.eventTimestamp = Instant.now();
    }

    /**
     * The user profile on which event occurred
     *
     * @return the {@link UserProfileInterests}
     */
    public UserProfileInterests getUserProfileInterests() {
        return (UserProfileInterests) getSource();
    }
}
