package com.finconsgroup.itserr.marketplace.userprofile.bs.client.dto;

import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotEmpty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;

import java.util.List;
import java.util.UUID;

/**
 * DTO for updating user profile info by provided ids.
 */
@Schema(name = "UpdateUserProfilesByIdsDto", description = "DTO for updating user profile details for provided ids")
@Data
@Builder
@AllArgsConstructor
public class InputFindUserProfilesByIdsDto {

    @NotEmpty
    @Schema(
            description = "Ids of the user profiles to retrieve details",
            example = "[\"550e8400-e29b-41d4-a716-446655440000\", \"550e8400-e29b-41d4-a716-446655449999\"]")
    List<UUID> ids;
}
