package com.finconsgroup.itserr.marketplace.userprofile.bs.client.dto;

import io.swagger.v3.oas.annotations.media.Schema;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.UUID;

/**
 * Output DTO representing a userprofile folderId.
 */
@Schema(name = "OutputUserProfileFolderDetails", description = "DTO representing a user profile folderId in responses")
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class OutputUserProfileFolderDetails {

    @Schema(description = "Unique identifier of the user profile", example = "550e8400-e29b-41d4-a716-446655440000")
    private UUID userId;

    @Schema(description = "Folder Id of the User Profile", example = "550e8400-e29b-41d4-a716-446655440000")
    private UUID userProfileFolderId;
}
