package com.finconsgroup.itserr.marketplace.userprofile.bs.client.dto;

import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.SuperBuilder;

import java.util.List;

/**
 * Data Transfer Object (DTO) representing the response containing a list of usernames
 * retrieved from the D4Science infrastructure.
 * This class encapsulates the success status, an optional message, and the list of users.
 */
@Data
@SuperBuilder
@NoArgsConstructor
@AllArgsConstructor
public class OutputUsernameListD4SDto {

    /**
     * Indicates whether the user list retrieval operation was successful.
     */
    private boolean success;

    /**
     * Optional message returned by the API, can be used for error descriptions or additional info.
     */
    private String message;

    /**
     * The map containing usernames retrieved from D4Science.
     */
    private List<String> result;
}
