package com.finconsgroup.itserr.marketplace.userprofile.bs.component;

import com.finconsgroup.itserr.marketplace.core.web.security.jwt.JwtTokenHolder;
import com.finconsgroup.itserr.marketplace.userprofile.bs.bean.UserProfileInterests;
import com.finconsgroup.itserr.marketplace.userprofile.bs.bean.UserProfileInterestsApplicationEvent;
import com.finconsgroup.itserr.marketplace.userprofile.bs.dto.UserProfileInterestsMessagingAdditionalDataDto;
import com.finconsgroup.itserr.marketplace.userprofile.bs.mapper.UserProfileMapper;
import com.finconsgroup.itserr.marketplace.userprofile.bs.messaging.EventProducer;
import com.finconsgroup.itserr.messaging.dto.MessagingEventDto;
import com.finconsgroup.itserr.messaging.dto.MessagingEventUserDto;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.context.ApplicationListener;
import org.springframework.lang.NonNull;
import org.springframework.stereotype.Component;

/**
 * The implementation for ApplicationListener to listen to User Profile Interests application events
 * and produce relevant messages.
 */
@Component
@Slf4j
@RequiredArgsConstructor
public class MessagingUserProfileInterestsApplicationEventListener implements ApplicationListener<UserProfileInterestsApplicationEvent> {

    private final EventProducer eventProducer;
    private final UserProfileMapper userProfileMapper;

    @Override
    public void onApplicationEvent(@NonNull UserProfileInterestsApplicationEvent event) {
        MessagingEventDto<UserProfileInterestsMessagingAdditionalDataDto> messagingEventDto =
                userProfileMapper.toMessagingEventDto(event.getUserProfileInterests());

        MessagingEventUserDto user = MessagingEventUserDto.builder()
                .id(JwtTokenHolder.getUserId().orElse(null))
                .name(JwtTokenHolder.getName().orElse(null))
                .username(JwtTokenHolder.getPreferredUsername().orElse(null))
                .build();
        messagingEventDto.setUser(user);

        UserProfileInterests userProfileInterests = event.getUserProfileInterests();
        messagingEventDto.setTimestamp(userProfileInterests.getTimestamp());

        UserProfileInterestsMessagingAdditionalDataDto additionalData = new UserProfileInterestsMessagingAdditionalDataDto();
        additionalData.setDescription(userProfileInterests.getDescription());
        additionalData.setNotifyUserIds(userProfileInterests.getNotifyUserIds());
        messagingEventDto.setAdditionalData(additionalData);

        eventProducer.publishInterestsEvent(messagingEventDto);
    }

}
