package com.finconsgroup.itserr.marketplace.userprofile.bs.dto;

import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.Size;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;

import java.util.UUID;

import static com.finconsgroup.itserr.marketplace.userprofile.bs.util.Constants.VALIDATION_ERROR_FIELD_LENGTH;

/**
 * DTO for expertise details.
 */
@Schema(name = "InputExpertiseDto", description = "Data Transfer Object representing a user's expertise input")
@Data
@Builder
@AllArgsConstructor
public class InputExpertiseDto {

    @Schema(description = "Unique identifier of the label", example = "550e8400-e29b-41d4-a716-446655440000")
    private UUID labelId;

    @Schema(description = "Display name of the expertise (e.g., skill name)", example = "Java Development")
    @Size(max = 100, message = VALIDATION_ERROR_FIELD_LENGTH)
    private String displayName;

}

