package com.finconsgroup.itserr.marketplace.userprofile.bs.dto;

import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotBlank;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.SuperBuilder;

@Data
@SuperBuilder
@NoArgsConstructor
@AllArgsConstructor
@Schema(
        name = "Folder create",
        description = "Represents a set of values to create a folder in a workspace")
public class InputFolderCreateDto {

    @NotBlank
    @Schema(description = "Name of the folder", example = "Biology")
    private String name;

    @NotBlank
    @Schema(description = "Description of the folder", example = "Containing info about cellular mitosis")
    private String description;

    //Not required at the present but might be used in future
    @Schema(description = "Boolean value indicating if a folder is hidden or not", example = "false")
    @Builder.Default
    private Boolean hidden = false;
}
