package com.finconsgroup.itserr.marketplace.userprofile.bs.dto;

import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.Size;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;

import java.net.URI;

import static com.finconsgroup.itserr.marketplace.userprofile.bs.util.Constants.VALIDATION_ERROR_FIELD_LENGTH;

/**
 * DTO for patching user profile info.
 */
@Schema(name = "PatchUserProfileDto", description = "DTO for patching user profile details")
@Data
@Builder
@AllArgsConstructor
public class InputPatchUserProfileDto {

    @Schema(description = "Link of the image of user", example = "https://imageLink")
    @Size(max = 255, message = VALIDATION_ERROR_FIELD_LENGTH)
    URI imageUri;

    @Schema(description = "CV details of the user")
    InputCVDto inputCVDto;

    @Schema(description = "User preferred language")
    private String language;

    @Schema(description = "Whether to show home panel or not", example = "false")
    private Boolean hidePanel;
}
