package com.finconsgroup.itserr.marketplace.userprofile.bs.dto;

import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.Size;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;

import java.util.UUID;

import static com.finconsgroup.itserr.marketplace.userprofile.bs.util.Constants.VALIDATION_ERROR_FIELD_LENGTH;

/**
 * DTO for project details.
 */
@Schema(name = "InputProjectDto", description = "DTO for project details")
@Data
@Builder
@AllArgsConstructor
public class InputProjectDto {

    @Schema(description = "Project Id", example = "550e8400-e29b-41d4-a716-446655440000")
    private UUID projectId;

    @Schema(description = "display name", example = "Criterion")
    @Size(max = 255, message = VALIDATION_ERROR_FIELD_LENGTH)
    private String displayName;

    @Schema(description = "Work package code", example = "wp3")
    @Size(max = 255, message = VALIDATION_ERROR_FIELD_LENGTH)
    private String wp;

    @Schema(description = "Root Project Id", example = "550e8400-e29b-41d4-a716-446655441111")
    private UUID rootProjectId;

    @Schema(description = "Root project display name", example = "WP3 - TRS")
    @Size(max = 255, message = VALIDATION_ERROR_FIELD_LENGTH)
    private String rootProjectDisplayName;

    @Schema(description = "leader of the work project", example = "false")
    private Boolean wpLead;
}
