package com.finconsgroup.itserr.marketplace.userprofile.bs.dto;

import io.swagger.v3.oas.annotations.media.Schema;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * Output DTO representing an author details.
 */
@Schema(name = "OutputEditorDto", description = "DTO representing a editor in responses")
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class OutputEditorDto {

    @Schema(description = "Surname of the author", example = "Doe")
    private String surname;

    @Schema(description = "Given name of the author", example = "John")
    private String givenName;

    @Schema(description = "ORCID of the author", example = "0000-0002-1825-0097")
    private String orcid;
}