package com.finconsgroup.itserr.marketplace.userprofile.bs.dto;

import io.swagger.v3.oas.annotations.media.Schema;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;

import java.time.LocalDate;

/**
 * DTO for publication.
 */
@Schema(name = "InputPublicationDto", description = "DTO for publication")
@Data
@Builder
@AllArgsConstructor
public class OutputPublicationDto {

    @Schema(description = "Publication date", example = "2024-05-01")
    private LocalDate date;

    @Schema(description = "Publication location details")
    private OutputWorkingLocationDto location;
}
